/*
 * Decompiled with CFR 0.152.
 */
package com.unclezs.novel.app.main.core;

import cn.hutool.core.collection.ListUtil;
import com.unclezs.novel.analyzer.common.concurrent.ThreadUtils;
import com.unclezs.novel.analyzer.common.page.AbstractPageable;
import com.unclezs.novel.analyzer.core.model.AnalyzerRule;
import com.unclezs.novel.analyzer.model.Novel;
import com.unclezs.novel.analyzer.spider.SearchSpider;
import com.unclezs.novel.app.framework.components.Toast;
import com.unclezs.novel.app.framework.executor.Executor;
import com.unclezs.novel.app.main.enums.SearchType;
import com.unclezs.novel.app.main.manager.RuleManager;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NovelSearcher {
    private static final Logger log = LoggerFactory.getLogger(NovelSearcher.class);
    private static ExecutorService service;
    private final List<SearchSpider> searchers = new ArrayList<SearchSpider>();
    private final AtomicInteger counter = new AtomicInteger();
    private final boolean audio;
    private final Callback callback;
    private String keyword;
    private boolean hasMore;
    private boolean searching;

    public NovelSearcher(boolean audio, Callback callback) {
        this.audio = audio;
        this.callback = callback;
    }

    public synchronized void doSearch(String keyword, String type) {
        List<AnalyzerRule> rules;
        if (service == null) {
            service = ThreadUtils.newFixedThreadPoolExecutor((int)10, (String)"search");
        }
        this.keyword = keyword;
        this.cancel();
        List<AnalyzerRule> list = rules = this.audio ? RuleManager.audioSearchRules() : RuleManager.textSearchRules();
        if (rules.isEmpty()) {
            Toast.warn((String)"\u672a\u53d1\u73b0\u53ef\u7528\u641c\u7d22\u4e66\u6e90");
            this.callback.showLoading(false);
            return;
        }
        this.counter.set(rules.size());
        this.hasMore = true;
        this.searching = true;
        this.callback.showLoading(true);
        for (AnalyzerRule rule : rules) {
            SearchSpider searcher = new SearchSpider(ListUtil.of((Object[])new AnalyzerRule[]{rule}));
            searcher.setOnNewItemAddHandler(novel -> {
                if (SearchType.match(type, keyword, novel)) {
                    Executor.runFx(() -> this.callback.addItem((Novel)novel));
                }
            });
            this.searchers.add(searcher);
            this.searchOrLoadMore(searcher, false);
        }
    }

    public void cancel() {
        if (!this.searchers.isEmpty()) {
            this.searchers.forEach(AbstractPageable::cancel);
        }
        this.searchers.clear();
        this.callback.showLoading(false);
        this.hasMore = false;
    }

    public synchronized void loadMore() {
        if (this.checkHasMore() && !this.searching) {
            this.searching = true;
            this.callback.showLoading(true);
            this.counter.set(this.searchers.size());
            this.searchers.forEach(searchSpider -> this.searchOrLoadMore((SearchSpider)searchSpider, true));
        }
    }

    public synchronized void searchOrLoadMore(SearchSpider searcher, boolean more) {
        service.execute(() -> {
            try {
                if (more) {
                    searcher.loadMore();
                } else {
                    searcher.search(this.keyword);
                }
            }
            catch (Exception e) {
                log.error("\u641c\u7d22\u5931\u8d25\uff1a{}", (Object)this.keyword, (Object)e);
            }
            finally {
                if (this.counter.decrementAndGet() == 0) {
                    this.checkHasMore();
                    this.searching = false;
                    Executor.runFx(() -> {
                        this.callback.showLoading(false);
                        if (!this.hasMore) {
                            this.callback.noMore();
                        }
                    });
                }
                if (!searcher.hasMore()) {
                    this.searchers.remove(searcher);
                }
            }
        });
    }

    private boolean checkHasMore() {
        this.hasMore = this.searchers.stream().anyMatch(AbstractPageable::hasMore);
        return this.hasMore;
    }

    public boolean isHasMore() {
        return this.hasMore;
    }

    public boolean isSearching() {
        return this.searching;
    }

    public static interface Callback {
        public void showLoading(boolean var1);

        public void addItem(Novel var1);

        default public void noMore() {
            Toast.info((String)"\u6ca1\u6709\u66f4\u591a\u4e86");
        }
    }
}

