/*
 * Decompiled with CFR 0.152.
 */
package com.unclezs.novel.app.main;

import cn.hutool.core.io.FileUtil;
import cn.hutool.core.lang.Dict;
import cn.hutool.core.util.URLUtil;
import com.unclezs.novel.analyzer.common.concurrent.ThreadUtils;
import com.unclezs.novel.app.framework.appication.BaseApplication;
import com.unclezs.novel.app.framework.appication.SceneView;
import com.unclezs.novel.app.framework.core.AppContext;
import com.unclezs.novel.app.framework.support.fonts.FontsLoader;
import com.unclezs.novel.app.framework.support.hotkey.HotKeyManager;
import com.unclezs.novel.app.framework.util.ResourceUtils;
import com.unclezs.novel.app.main.manager.HotkeyManager;
import com.unclezs.novel.app.main.manager.ResourceManager;
import com.unclezs.novel.app.main.manager.SettingManager;
import com.unclezs.novel.app.main.manager.TrayManager;
import com.unclezs.novel.app.main.util.MixPanelHelper;
import com.unclezs.novel.app.main.util.TimeUtil;
import com.unclezs.novel.app.main.util.UpdateUtils;
import com.unclezs.novel.app.main.views.home.HomeView;
import java.io.File;
import java.util.Map;
import javafx.application.Platform;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.collections.ObservableList;
import javafx.event.Event;
import javafx.scene.Scene;
import javafx.scene.image.Image;
import javafx.scene.layout.Region;
import javafx.stage.Stage;
import javafx.stage.StageStyle;
import javafx.stage.Window;
import javafx.stage.WindowEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class App
extends BaseApplication {
    private static final Logger log = LoggerFactory.getLogger(App.class);
    public static final File FONT_CSS_FILE = ResourceManager.confFile("font.css");
    public static final String FONT_CSS_FORMAT = ".root{-fx-font-family: '%s';}";
    public static final String FONT_CSS_URL = URLUtil.getURL((File)FONT_CSS_FILE).toExternalForm();
    public static final boolean SHOW_INFO = false;
    public static final String NAME = "Uncle\u5c0f\u8bf4";
    private static final String EVENT_LAUNCH = "\u542f\u52a8\u5e94\u7528";
    private static final String EVENT_STOP = "\u505c\u6b62\u5e94\u7528";
    private static final long LAUNCH_TIME = System.currentTimeMillis();
    protected ObjectProperty<String> font = new SimpleObjectProperty();

    public static void main(String[] args) {
        App.launch((String[])args);
    }

    public static Stage stage() {
        return AppContext.getInstance().getPrimaryStage();
    }

    public static void requestShow() {
        if (!App.stage().isShowing()) {
            Platform.setImplicitExit((boolean)false);
            App.stage().show();
        }
        App.stage().toFront();
    }

    public static void tray() {
        Platform.setImplicitExit((boolean)false);
        App.stage().fireEvent((Event)new WindowEvent((Window)App.stage(), WindowEvent.WINDOW_CLOSE_REQUEST));
    }

    public static void stopApp() {
        Platform.setImplicitExit((boolean)true);
        App.stage().fireEvent((Event)new WindowEvent((Window)App.stage(), WindowEvent.WINDOW_CLOSE_REQUEST));
        App.destroy();
        ThreadUtils.newThread(() -> {
            SettingManager.save();
            HotKeyManager.unbind();
            MixPanelHelper.sendEvent(EVENT_STOP, (Map<String, Object>)Dict.create().set("\u4f7f\u7528\u65f6\u5e38", (Object)TimeUtil.secondToTime((double)(System.currentTimeMillis() - LAUNCH_TIME) / 1000.0)));
            System.exit(0);
        }, (boolean)false).start();
    }

    public void init() throws Exception {
        super.init();
        SettingManager.init();
        TrayManager.init();
        HotkeyManager.init();
        FontsLoader.loadFonts((File)ResourceManager.FONTS_DIR);
    }

    public void start(Stage stage) throws Exception {
        super.init();
        super.start(stage);
        this.initStage(stage);
        stage.show();
        UpdateUtils.checkForUpdate(stage);
        MixPanelHelper.event(EVENT_LAUNCH);
        log.trace("\u542f\u52a8\u8017\u65f6\uff1a{}ms", (Object)(System.currentTimeMillis() - LAUNCH_TIME));
    }

    private void initStage(Stage stage) {
        String[] icons;
        stage.initStyle(StageStyle.TRANSPARENT);
        for (String icon : icons = new String[]{"16", "32", "48", "64", "128"}) {
            stage.getIcons().add((Object)new Image(ResourceUtils.stream((String)String.format("assets/logo/icon-%s.png", icon))));
        }
    }

    public SceneView<? extends Region> getIndexView() {
        return (SceneView)AppContext.getView(HomeView.class);
    }

    public void onSceneChange(Scene scene) {
        super.onSceneChange(scene);
        this.changeFont((String)SettingManager.manager().getBasic().getFonts().get());
    }

    public void changeFont(String font) {
        String css = String.format(FONT_CSS_FORMAT, font);
        FileUtil.writeUtf8String((String)css, (File)FONT_CSS_FILE);
        ObservableList stylesheets = ((Region)this.currentView.getRoot()).getScene().getStylesheets();
        stylesheets.remove((Object)FONT_CSS_URL);
        stylesheets.add((Object)FONT_CSS_URL);
    }
}

