/*
 * Decompiled with CFR 0.152.
 */
package com.unclezs.novel.analyzer.util.uri;

import com.unclezs.novel.analyzer.util.regex.RegexUtils;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;

public class UrlEncoder {
    private UrlEncoder() {
    }

    public static String encode(String url, String charset) {
        StringBuilder toUrl = new StringBuilder();
        for (char c : url.toCharArray()) {
            String word = String.valueOf(c);
            if (RegexUtils.isChinese(word)) {
                try {
                    toUrl.append(URLEncoder.encode(word, charset));
                }
                catch (UnsupportedEncodingException e) {
                    toUrl.append(c);
                    e.printStackTrace();
                }
                continue;
            }
            toUrl.append(c);
        }
        return toUrl.toString();
    }

    public static String encode(String keyword) {
        try {
            return URLEncoder.encode(keyword, StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return keyword;
        }
    }

    public static String deCodeUnicode(String src) {
        StringBuilder tmp = new StringBuilder();
        tmp.ensureCapacity(src.length());
        int lastPos = 0;
        src = src.replace("&#x", "%u").replace(";", "");
        while (lastPos < src.length()) {
            int pos = src.indexOf("%", lastPos);
            if (pos == lastPos) {
                char ch;
                if (src.charAt(pos + 1) == 'u') {
                    ch = (char)Integer.parseInt(src.substring(pos + 2, pos + 6), 16);
                    tmp.append(ch);
                    lastPos = pos + 6;
                    continue;
                }
                ch = (char)Integer.parseInt(src.substring(pos + 1, pos + 3), 16);
                tmp.append(ch);
                lastPos = pos + 3;
                continue;
            }
            if (pos == -1) {
                tmp.append(src.substring(lastPos));
                lastPos = src.length();
                continue;
            }
            tmp.append(src, lastPos, pos);
            lastPos = pos;
        }
        return tmp.toString();
    }
}

