/*
 * Decompiled with CFR 0.152.
 */
package com.unclezs.novel.analyzer.util.regex;

import com.unclezs.novel.analyzer.common.exception.UtilException;
import com.unclezs.novel.analyzer.util.CollectionUtils;
import com.unclezs.novel.analyzer.util.StringUtils;
import com.unclezs.novel.analyzer.util.regex.PatternPool;
import java.nio.charset.Charset;
import java.nio.charset.UnsupportedCharsetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class RegexUtils {
    public static final Pattern NUMBERS = Pattern.compile("\\d+");
    public static final String CHINESE = "\\u4E00-\\u9FFF";
    public static final Pattern CHINESE_REG = Pattern.compile("[\\u4E00-\\u9FFF]");
    public static final Pattern HAS_CHINESE_REG = Pattern.compile("[\\u4E00-\\u9FFF]");
    public static final Pattern NOT_CHINESE_AND_NOT_NUMBER = Pattern.compile("([^\\u4E00-\\u9FFF]|[\u4e00\u4e8c\u4e09\u56db\u4e94\u516d\u4e03\u516b\u4e5d\u5341\u96f6])");
    public static final String UNICODE_LETTER_NUMBER = "\\uFF41-\\uFF5a\\uFF21-\\uFF3a\\uFF10-\\uFF19";
    public static final String CHINESE_PUNCTUATION = "~\\u000A\\u0009\\u00A0\\u0020\\u3000\\uFEFF";
    public static final Pattern WORD = Pattern.compile("[a-zA-Z]+");
    public static final Pattern CONTAINS_CHAR = Pattern.compile(".*?[a-zA-Z].*?");
    public static final Pattern CONTAINS_NUMBER = Pattern.compile(".*?[0-9].*?");
    public static final Set<Character> RE_KEYS = CollectionUtils.newSet(Character.valueOf('$'), Character.valueOf('('), Character.valueOf(')'), Character.valueOf('*'), Character.valueOf('+'), Character.valueOf('.'), Character.valueOf('['), Character.valueOf(']'), Character.valueOf('?'), Character.valueOf('\\'), Character.valueOf('^'), Character.valueOf('{'), Character.valueOf('}'), Character.valueOf('|'));

    public static boolean isNumber(String src) {
        return NUMBERS.matcher(src).matches();
    }

    public static boolean isChinese(CharSequence src) {
        return CHINESE_REG.matcher(src).matches();
    }

    public static boolean containChinese(CharSequence src) {
        return CHINESE_REG.matcher(src).find();
    }

    public static boolean isWord(String src) {
        return WORD.matcher(src).matches();
    }

    public static String removeNotChineseAndNotNumber(String content) {
        return NOT_CHINESE_AND_NOT_NUMBER.matcher(content).replaceAll("");
    }

    public static String get(String regex, CharSequence content, int groupIndex) {
        if (null == content || null == regex) {
            return null;
        }
        Pattern pattern = PatternPool.get(regex, 2);
        return RegexUtils.get(pattern, content, groupIndex);
    }

    public static String get(Pattern pattern, CharSequence content, int groupIndex) {
        if (null == content || null == pattern) {
            return null;
        }
        Matcher matcher = pattern.matcher(content);
        if (matcher.find()) {
            return matcher.group(groupIndex);
        }
        return null;
    }

    public static List<String> getAllGroups(Pattern pattern, CharSequence content, boolean withGroup0) {
        if (null == content || null == pattern) {
            return null;
        }
        ArrayList<String> result = new ArrayList<String>();
        Matcher matcher = pattern.matcher(content);
        if (matcher.find()) {
            int startGroup = withGroup0 ? 0 : 1;
            int groupCount = matcher.groupCount();
            for (int i = startGroup; i <= groupCount; ++i) {
                result.add(matcher.group(i));
            }
        }
        return result;
    }

    public static boolean isMatch(String regex, CharSequence content) {
        if (content == null) {
            return false;
        }
        if (StringUtils.isEmpty(regex)) {
            return true;
        }
        Pattern pattern = PatternPool.get(regex, 2);
        return RegexUtils.isMatch(pattern, content);
    }

    public static boolean isMatch(Pattern pattern, CharSequence content) {
        if (content == null || pattern == null) {
            return false;
        }
        return pattern.matcher(content).matches();
    }

    public static String findByTemplate(Pattern pattern, CharSequence content, String template) {
        if (null == content || null == pattern || null == template) {
            return null;
        }
        TreeSet<Integer> varNums = RegexUtils.getTemplateGroups(template);
        Matcher matcher = pattern.matcher(content);
        if (matcher.find()) {
            for (Integer group : varNums) {
                template = template.replace("$" + group, matcher.group(group));
            }
            return template;
        }
        return null;
    }

    public static List<String> findAllByTemplate(Pattern pattern, CharSequence content, String template) {
        if (null == content || null == pattern || null == template) {
            return null;
        }
        TreeSet<Integer> varNums = RegexUtils.getTemplateGroups(template);
        Matcher matcher = pattern.matcher(content);
        ArrayList<String> items = new ArrayList<String>();
        while (matcher.find()) {
            for (Integer group : varNums) {
                items.add(template.replace("$" + group, matcher.group(group)));
            }
        }
        return items;
    }

    public static List<String> findAllByTemplate(String regex, CharSequence content, String template) {
        if (null == content || null == regex || null == template) {
            return null;
        }
        Pattern pattern = PatternPool.get(regex, 32);
        return RegexUtils.findAllByTemplate(pattern, content, template);
    }

    private static TreeSet<Integer> getTemplateGroups(String template) {
        TreeSet<Integer> varNums = new TreeSet<Integer>();
        Matcher matcherForTemplate = PatternPool.GROUP_VAR.matcher(template);
        while (matcherForTemplate.find()) {
            varNums.add(Integer.parseInt(matcherForTemplate.group(1)));
        }
        return varNums;
    }

    public static String findByTemplate(String regex, CharSequence content, String template) {
        if (null == content || null == regex || null == template) {
            return null;
        }
        Pattern pattern = PatternPool.get(regex, 32);
        return RegexUtils.findByTemplate(pattern, content, template);
    }

    public static <T extends Collection<String>> T findAll(Pattern pattern, CharSequence content, int group, T collection) {
        if (null == pattern || null == content) {
            return null;
        }
        if (null == collection) {
            throw new NullPointerException("Null collection param provided!");
        }
        Matcher matcher = pattern.matcher(content);
        while (matcher.find()) {
            collection.add((String)matcher.group(group));
        }
        return collection;
    }

    public static String replaceAll(CharSequence content, String regex, String replacementTemplate) {
        Pattern pattern = Pattern.compile(regex, 32);
        return RegexUtils.replaceAll(content, pattern, replacementTemplate);
    }

    public static String replaceAll(CharSequence content, Pattern pattern, String replacementTemplate) {
        boolean result;
        if (StringUtils.isEmpty(content)) {
            return StringUtils.str(content);
        }
        Matcher matcher = pattern.matcher(content);
        if (replacementTemplate == null) {
            replacementTemplate = "";
        }
        if (result = matcher.find()) {
            Set varNums = RegexUtils.findAll(PatternPool.GROUP_VAR, replacementTemplate, 1, new HashSet());
            StringBuffer sb = new StringBuffer();
            do {
                String replacement = replacementTemplate;
                for (String var : varNums) {
                    int group = Integer.parseInt(var);
                    replacement = replacement.replace("$" + var, matcher.group(group));
                }
                matcher.appendReplacement(sb, RegexUtils.escape(replacement));
            } while (result = matcher.find());
            matcher.appendTail(sb);
            return sb.toString();
        }
        return StringUtils.str(content);
    }

    public static String replaceAll(CharSequence str, String regex, Function<Matcher, String> replaceFun) {
        return RegexUtils.replaceAll(str, Pattern.compile(regex), replaceFun);
    }

    public static String replaceAll(CharSequence str, Pattern pattern, Function<Matcher, String> replaceFun) {
        if (StringUtils.isEmpty(str)) {
            return StringUtils.str(str);
        }
        Matcher matcher = pattern.matcher(str);
        StringBuffer buffer = new StringBuffer();
        while (matcher.find()) {
            try {
                matcher.appendReplacement(buffer, replaceFun.apply(matcher));
            }
            catch (Exception e) {
                throw new UtilException(e);
            }
        }
        matcher.appendTail(buffer);
        return buffer.toString();
    }

    public static String escape(char c) {
        StringBuilder builder = new StringBuilder();
        if (RE_KEYS.contains(Character.valueOf(c))) {
            builder.append('\\');
        }
        builder.append(c);
        return builder.toString();
    }

    public static String escape(CharSequence content) {
        if (StringUtils.isBlank(content)) {
            return StringUtils.str(content);
        }
        StringBuilder builder = new StringBuilder();
        int len = content.length();
        for (int i = 0; i < len; ++i) {
            char current = content.charAt(i);
            if (RE_KEYS.contains(Character.valueOf(current))) {
                builder.append('\\');
            }
            builder.append(current);
        }
        return builder.toString();
    }

    public static String matchHtmlCharset(String html) {
        Matcher matcher = PatternPool.HTML_CHARSET.matcher(html);
        if (matcher.find()) {
            String charset = matcher.group("default");
            if (StringUtils.isEmpty(charset)) {
                charset = matcher.group("match");
            }
            if (charset != null) {
                try {
                    Charset.forName(charset);
                }
                catch (UnsupportedCharsetException e) {
                    charset = null;
                }
            }
            return charset;
        }
        return null;
    }

    public static int getStringType(String source) {
        int type = 0;
        if (CONTAINS_NUMBER.matcher(source).matches()) {
            type = 1;
        }
        if (CONTAINS_CHAR.matcher(source).matches()) {
            type += 2;
        }
        return type;
    }

    private RegexUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

