/*
 * Decompiled with CFR 0.152.
 */
package com.unclezs.novel.analyzer.util;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.reflect.TypeToken;
import java.util.List;
import java.util.Map;

public final class GsonUtils {
    public static final Gson GSON = new GsonBuilder().setDateFormat("yyyy-MM-dd HH:mm:ss").disableHtmlEscaping().create();
    public static final Gson NULL_PRETTY = new GsonBuilder().serializeNulls().setPrettyPrinting().disableHtmlEscaping().create();
    public static final Gson PRETTY = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();

    public static Gson me() {
        return GSON;
    }

    public static String toJson(Object object) {
        String json = null;
        if (GSON != null) {
            json = GSON.toJson(object);
        }
        return json;
    }

    public static <T> T parse(String json, Class<T> cls) {
        Object t = null;
        if (GSON != null) {
            t = GSON.fromJson(json, cls);
        }
        return (T)t;
    }

    public static <T> Map<String, T> toMap(String json) {
        Map map = null;
        if (GSON != null) {
            map = (Map)GSON.fromJson(json, new TypeToken<Map<String, T>>(){}.getType());
        }
        return map;
    }

    public static <T> List<T> toList(String json) {
        List list = null;
        if (GSON != null) {
            list = (List)GSON.fromJson(json, new TypeToken<List<T>>(){}.getType());
        }
        return list;
    }

    public static String getOrDefault(JsonObject jsonObject, String key, String defaultValue) {
        JsonElement jsonElement = jsonObject.get(key);
        if (jsonElement == null) {
            return defaultValue;
        }
        return jsonElement.getAsString();
    }

    public static String get(JsonObject jsonObject, String key) {
        JsonElement jsonElement = jsonObject.get(key);
        if (jsonElement == null) {
            return null;
        }
        return jsonElement.getAsString();
    }

    private GsonUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

