/*
 * Decompiled with CFR 0.152.
 */
package com.unclezs.novel.analyzer.spider.pipline;

import com.unclezs.novel.analyzer.common.exception.SpiderRuntimeException;
import com.unclezs.novel.analyzer.model.Chapter;
import com.unclezs.novel.analyzer.request.Http;
import com.unclezs.novel.analyzer.request.RequestParams;
import com.unclezs.novel.analyzer.spider.pipline.BaseFilePipeline;
import com.unclezs.novel.analyzer.util.FileUtils;
import com.unclezs.novel.analyzer.util.StringUtils;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MediaFilePipeline
extends BaseFilePipeline {
    private static final Logger log = LoggerFactory.getLogger(MediaFilePipeline.class);
    public static final String MEDIA_TYPE_M4A = "m4a";
    private static final String DOWNLOAD_FILE_FORMAT = "%s/%s.%s";
    private static final String MEDIA_TYPE_MP3 = "mp3";
    public static final int KB_5 = 5120;

    @Override
    public void process(Chapter chapter) {
        String downloadFile = String.format(DOWNLOAD_FILE_FORMAT, this.getFilePath(), StringUtils.removeInvalidSymbol(chapter.getName()), this.getType(chapter.getContent()));
        try {
            RequestParams requestParams = RequestParams.create(chapter.getContent());
            requestParams.addHeader("Referer", chapter.getUrl());
            byte[] bytes = Http.bytes(requestParams);
            if (bytes.length < 5120) {
                throw new SpiderRuntimeException("\u97f3\u9891\u5927\u5c0f\u592a\u5c0f\uff0c\u8ba4\u5b9a\u4e3a\u5931\u8d25");
            }
            FileUtils.writeBytes(downloadFile, bytes);
        }
        catch (IOException e) {
            log.error("\u4fdd\u5b58\u7ae0\u8282\u5185\u5bb9\u5230\uff1a{} \u5931\u8d25.", (Object)downloadFile, (Object)e);
            throw new SpiderRuntimeException("\u97f3\u9891\u6293\u53d6\u5931\u8d25");
        }
    }

    private String getType(String page) {
        String type;
        int typeSplitIndex = page.lastIndexOf(".");
        if (typeSplitIndex > 0 && MEDIA_TYPE_M4A.equalsIgnoreCase(type = page.substring(typeSplitIndex + 1))) {
            return MEDIA_TYPE_M4A;
        }
        return MEDIA_TYPE_MP3;
    }
}

