/*
 * Decompiled with CFR 0.152.
 */
package com.unclezs.novel.analyzer.spider.helper;

import com.unclezs.novel.analyzer.core.helper.DebugHelper;
import com.unclezs.novel.analyzer.request.RequestParams;
import com.unclezs.novel.analyzer.script.ScriptUtils;
import com.unclezs.novel.analyzer.util.StringUtils;
import com.unclezs.novel.analyzer.util.regex.RegexUtils;
import com.unclezs.novel.analyzer.util.uri.UrlEncoder;
import java.util.HashMap;
import java.util.Map;
import javax.script.SimpleBindings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SearchHelper {
    private static final Logger log = LoggerFactory.getLogger(SearchHelper.class);
    public static final String SEARCH_KEYWORD = "keyword";
    public static final String SEARCH_PAGE = "page";

    public static String pretreatmentParam(String src, String param, String paramValue) {
        String script = RegexUtils.get("\\{\\{([^{]*?" + param + ".*?)\\}\\}", (CharSequence)src, 1);
        if (StringUtils.isNotBlank(script) && !script.trim().equalsIgnoreCase(param)) {
            SimpleBindings bindings = new SimpleBindings();
            bindings.put(param, (Object)paramValue);
            paramValue = ScriptUtils.execute(script, bindings);
        }
        return src.replaceAll("\\{\\{[^{]*?" + param + ".*?\\}\\}", paramValue);
    }

    public static String pretreatmentParams(String src, Map<String, String> params) {
        if (StringUtils.isBlank(src)) {
            return src;
        }
        for (Map.Entry<String, String> param : params.entrySet()) {
            src = SearchHelper.pretreatmentParam(src, param.getKey(), param.getValue());
        }
        return src;
    }

    public static void pretreatmentSearchParam(RequestParams params, int page, String keyword) {
        String encodeKeyword;
        if (StringUtils.isNotBlank(params.getCharset())) {
            encodeKeyword = UrlEncoder.encode(keyword, params.getCharset());
            DebugHelper.debug("\u3010\u641c\u7d22\u3011\uff1a\u8bf7\u6c42\u53c2\u6570\u6307\u5b9a{}\u7f16\u7801\uff0c\u5173\u952e\u8bcd\uff1a\u3010{}\u3011\u7f16\u7801\u540e\uff1a\u3010{}\u3011", params.getCharset(), keyword, encodeKeyword);
        } else {
            DebugHelper.debug("\u3010\u641c\u7d22\u3011\uff1a\u8bf7\u6c42\u53c2\u6570\u672a\u6307\u5b9a\u7f16\u7801\uff0c\u4e0d\u7f16\u7801\u5173\u952e\u8bcd: \u3010{}\u3011", keyword);
            encodeKeyword = keyword;
        }
        HashMap<String, String> paramsMap = new HashMap<String, String>(2);
        paramsMap.put(SEARCH_PAGE, String.valueOf(page));
        paramsMap.put(SEARCH_KEYWORD, encodeKeyword);
        params.setUrl(SearchHelper.pretreatmentParams(params.getUrl(), paramsMap));
        params.setBody(SearchHelper.pretreatmentParams(params.getBody(), paramsMap));
        DebugHelper.debug("\u3010\u641c\u7d22\u3011\uff1a\u8bf7\u6c42\u53c2\u6570\u7f16\u7801\u540e: url = {} \uff0c body = {} ", params.getUrl(), params.getBody());
    }

    private SearchHelper() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

