/*
 * Decompiled with CFR 0.152.
 */
package com.unclezs.novel.analyzer.spider;

import com.unclezs.novel.analyzer.AnalyzerManager;
import com.unclezs.novel.analyzer.common.concurrent.ThreadUtils;
import com.unclezs.novel.analyzer.common.exception.SpiderRuntimeException;
import com.unclezs.novel.analyzer.common.exception.TaskCanceledException;
import com.unclezs.novel.analyzer.core.model.AnalyzerRule;
import com.unclezs.novel.analyzer.model.Chapter;
import com.unclezs.novel.analyzer.model.ChapterState;
import com.unclezs.novel.analyzer.model.Novel;
import com.unclezs.novel.analyzer.spider.NovelSpider;
import com.unclezs.novel.analyzer.spider.helper.SpiderHelper;
import com.unclezs.novel.analyzer.spider.pipline.BaseFilePipeline;
import com.unclezs.novel.analyzer.spider.pipline.ConsolePipeline;
import com.unclezs.novel.analyzer.spider.pipline.Pipeline;
import com.unclezs.novel.analyzer.util.CollectionUtils;
import com.unclezs.novel.analyzer.util.FileUtils;
import com.unclezs.novel.analyzer.util.RandomUtils;
import com.unclezs.novel.analyzer.util.StringUtils;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.BiConsumer;
import java.util.function.IntConsumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Spider
implements Serializable {
    private static final Logger log = LoggerFactory.getLogger(Spider.class);
    public static final int READY = 1;
    public static final int RUNNING = 2;
    public static final int PAUSED = 3;
    public static final int COMPLETE = 4;
    public static final int PIPELINE = 5;
    public static final int STOPPED = 6;
    public static final int SUCCESS = 7;
    private static final AtomicInteger COUNTER = new AtomicInteger(1);
    private final transient AtomicInteger state = new AtomicInteger();
    private final transient ReentrantLock runLock = new ReentrantLock();
    private final AtomicInteger successCount = new AtomicInteger(0);
    private final AtomicInteger errorCount = new AtomicInteger(0);
    private transient NovelSpider novelSpider;
    private transient ThreadPoolExecutor threadPool;
    private transient BiConsumer<Double, String> progressChangeHandler;
    private transient List<Pipeline> pipelines = new ArrayList<Pipeline>();
    private transient CopyOnWriteArraySet<Task> tasks = new CopyOnWriteArraySet();
    private int threadNum = 1;
    private AnalyzerRule analyzerRule;
    private int currentTimes = 0;
    private int retryTimes = 0;
    private boolean ignoreError;
    private List<Chapter> toc;
    private Novel novel;
    private String url;
    private int totalCount = 0;
    private String savePath;
    private transient IntConsumer onStateChange;

    public Spider setNovel(Novel novel) {
        this.novel = novel;
        if (CollectionUtils.isNotEmpty(novel.getChapters())) {
            this.toc = novel.getChapters();
        }
        return this;
    }

    public int state() {
        return this.state.get();
    }

    public Spider setThreadNum(int threadNum) {
        if (threadNum < 1) {
            threadNum = 1;
        }
        this.threadNum = threadNum;
        if (this.threadPool != null) {
            this.threadPool.setCorePoolSize(threadNum);
            this.threadPool.setMaximumPoolSize(threadNum);
        }
        return this;
    }

    public Spider addPipeline(Pipeline pipeline) {
        this.pipelines.add(pipeline);
        return this;
    }

    private void validate() {
        if (StringUtils.isBlank(this.url)) {
            throw new SpiderRuntimeException("\u76ee\u5f55\u5730\u5740\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (this.analyzerRule == null) {
            throw new SpiderRuntimeException("\u89e3\u6790\u89c4\u5219\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    private void setChapterOrder(Pipeline pipeline) {
        File novelDir;
        String novelSavePath = ((BaseFilePipeline)pipeline).getFilePath();
        int order = 1;
        if (FileUtils.exist(novelSavePath) && (novelDir = new File(novelSavePath)).isDirectory()) {
            File[] files = novelDir.listFiles((dir1, name) -> name.endsWith(".txt"));
            order = files.length + 1;
        }
        for (Chapter chapter : this.toc) {
            chapter.setOrder(order++);
        }
        this.novel.setChapters(this.toc);
        this.totalCount = this.toc.size();
    }

    private void init() throws IOException {
        this.validate();
        this.novelSpider = new NovelSpider();
        this.novelSpider.setRule(this.analyzerRule);
        if (this.novel == null) {
            this.novel = this.novelSpider.details(this.url);
            this.novel.setUrl(this.url);
            log.trace("\u6293\u53d6\u5230\u5c0f\u8bf4\u8be6\u60c5\u4fe1\u606f\uff1a{}", (Object)this.novel);
        }
        if (StringUtils.isBlank(this.novel.getTitle())) {
            this.novel.setTitle("\u672a\u77e5\u6807\u9898" + RandomUtils.randomInt(1000));
        }
        if (CollectionUtils.isEmpty(this.toc)) {
            this.toc = this.novelSpider.toc(this.url);
            if (CollectionUtils.isEmpty(this.toc)) {
                log.warn("\u7ae0\u8282\u6570\u636e\u6293\u53d6\u5931\u8d25\u6216\u672a\u83b7\u53d6\u5230\u7ae0\u8282\uff1a{}", (Object)this.url);
                throw new SpiderRuntimeException("\u7ae0\u8282\u6570\u636e\u6293\u53d6\u5931\u8d25\u6216\u672a\u83b7\u53d6\u5230\u7ae0\u8282:" + this.url);
            }
        }
        if (this.pipelines.isEmpty()) {
            this.pipelines.add(new ConsolePipeline());
        }
        this.pipelines.forEach(pipeline -> {
            if (pipeline instanceof BaseFilePipeline && StringUtils.isNotBlank(this.savePath)) {
                ((BaseFilePipeline)pipeline).setPath(this.savePath);
            }
            pipeline.injectNovel(this.novel);
            this.setChapterOrder((Pipeline)pipeline);
        });
        this.tasks = new CopyOnWriteArraySet();
        this.threadPool = ThreadUtils.newFixedThreadPoolExecutor(this.threadNum, String.format("spider-%d", COUNTER.getAndIncrement()));
        this.progressChangeHandler.accept(this.progress(), this.progressText());
        this.setState(1);
    }

    private void crawling() {
        if (this.isSucceed()) {
            this.setState(7);
            return;
        }
        log.debug("\u5f00\u59cb\u722c\u53d6\u5c0f\u8bf4[{}]\uff1a\u5df2\u4e0b\u8f7d{}/{}\u7ae0 \u5f00\u542f{}\u4e2a\u7ebf\u7a0b \u662f\u5426\u542f\u7528\u81ea\u52a8\u4ee3\u7406\uff1a{}", new Object[]{this.novel.getTitle(), this.successCount, this.toc.size(), this.threadNum, AnalyzerManager.me().isAutoProxy()});
        this.tasks.clear();
        boolean isPaused = this.isState(3);
        this.setState(2);
        this.toc.stream().filter(chapter -> isPaused ? chapter.getState() == ChapterState.INIT : !chapter.downloaded()).forEach(chapter -> this.threadPool.execute(new Task((Chapter)chapter)));
        while (!this.tasks.isEmpty() && !this.isState(3, 6)) {
        }
        if (this.isSucceed()) {
            log.debug("\u5c0f\u8bf4\u3010{}\u3011\u5df2\u7ecf\u5168\u90e8\u6293\u53d6\u6210\u529f", (Object)this.novel.getTitle());
            this.doLast();
        }
    }

    public void run() {
        if (this.runLock.tryLock()) {
            try {
                if (this.ignoreError && this.isState(4)) {
                    this.doLast();
                    return;
                }
                if (!this.isExceed(1)) {
                    this.init();
                }
                if (this.isExceed(5)) {
                    return;
                }
                while (this.currentTimes <= this.retryTimes) {
                    this.crawling();
                    if (this.isState(3, 6, 7)) break;
                    ++this.currentTimes;
                }
                if (this.currentTimes > this.retryTimes && !this.isState(3, 6, 7)) {
                    this.setState(4);
                }
            }
            catch (Exception e) {
                log.error("\u5c0f\u8bf4{}\u6293\u53d6\u5931\u8d25", (Object)this.url, (Object)e);
            }
            finally {
                this.runLock.unlock();
            }
        }
    }

    public void runAsync() {
        ThreadUtils.execute(this::run);
    }

    private void setState(int state) {
        if (this.isExceed(5) && state != 7) {
            return;
        }
        this.state.set(state);
        if (this.onStateChange != null) {
            this.onStateChange.accept(state);
        }
        this.handleChangeState(state);
    }

    private boolean isSucceed() {
        return this.toc.stream().allMatch(Chapter::downloaded);
    }

    private void handleChangeState(int state) {
        switch (state) {
            case 3: {
                this.cancelRunningTasks();
                log.trace("\u5c0f\u8bf4[{}]\u6293\u53d6\u5df2\u7ecf\u6682\u505c\uff1a\u5df2\u4e0b\u8f7d{}/{}\u7ae0", new Object[]{this.novel.getTitle(), this.successCount.get(), this.toc.size()});
                break;
            }
            case 4: {
                log.trace("\u5c0f\u8bf4[{}]\u6293\u53d6\u5b8c\u6210\uff1a\u5df2\u4e0b\u8f7d{}/{}\u7ae0\uff0c\u9519\u8bef\u7ae0\u8282\uff1a{}", new Object[]{this.novel.getTitle(), this.successCount.get(), this.toc.size(), this.errorCount()});
                break;
            }
            case 5: {
                this.pipelines.forEach(Pipeline::onComplete);
                log.trace("\u5c0f\u8bf4[{}]\u6293\u53d6\u5b8c\u6210\uff0c\u7b49\u5f85\u7ba1\u9053\u5904\u7406\u5b8c\u6210", (Object)this.novel.getTitle());
                break;
            }
            case 6: {
                log.trace("\u5c0f\u8bf4[{}]\u6293\u53d6\u5df2\u505c\u6b62 - \u4efb\u52a1\u4e22\u5f03", (Object)this.novel.getTitle());
                this.shutdown();
                break;
            }
            case 7: {
                log.debug("\u5c0f\u8bf4[{}]\u6293\u53d6\u6210\u529f\uff1a\u5171{}\u7ae0", (Object)this.novel.getTitle(), (Object)this.toc.size());
                this.shutdown();
                break;
            }
        }
    }

    public boolean isState(int ... states) {
        return Arrays.stream(states).anyMatch(value -> this.state() == value);
    }

    public boolean isExceed(int state) {
        return this.state() >= state;
    }

    public void cancelRunningTasks() {
        if (this.tasks != null) {
            this.tasks.forEach(Task::cancel);
        }
        if (this.threadPool != null) {
            this.threadPool.getQueue().clear();
        }
    }

    private void shutdown() {
        this.cancelRunningTasks();
        if (this.threadPool != null) {
            this.threadPool.shutdown();
        }
        this.toc = null;
        this.novel = null;
        this.threadPool = null;
        this.pipelines = null;
        this.progressChangeHandler = null;
    }

    public void pause() {
        if (this.isExceed(1) && !this.isSucceed()) {
            this.setState(3);
        }
    }

    public void stop() {
        this.setState(6);
    }

    private void doLast() {
        this.setState(5);
        this.setState(7);
    }

    public void resetRetryTimes() {
        if (this.isState(4)) {
            this.currentTimes = 0;
            log.trace("\u91cd\u7f6e\u91cd\u8bd5\u6b21\u6570\u4e3a\uff1a0/{}", (Object)this.retryTimes);
        }
    }

    public double progress() {
        return (double)this.successCount.get() / (double)this.totalCount;
    }

    public String progressText() {
        return String.format("%d/%d", this.successCount.get(), this.totalCount);
    }

    public int errorCount() {
        return this.errorCount.get();
    }

    public AtomicInteger getState() {
        return this.state;
    }

    public ReentrantLock getRunLock() {
        return this.runLock;
    }

    public AtomicInteger getSuccessCount() {
        return this.successCount;
    }

    public AtomicInteger getErrorCount() {
        return this.errorCount;
    }

    public ThreadPoolExecutor getThreadPool() {
        return this.threadPool;
    }

    public BiConsumer<Double, String> getProgressChangeHandler() {
        return this.progressChangeHandler;
    }

    public List<Pipeline> getPipelines() {
        return this.pipelines;
    }

    public CopyOnWriteArraySet<Task> getTasks() {
        return this.tasks;
    }

    public int getThreadNum() {
        return this.threadNum;
    }

    public AnalyzerRule getAnalyzerRule() {
        return this.analyzerRule;
    }

    public int getCurrentTimes() {
        return this.currentTimes;
    }

    public int getRetryTimes() {
        return this.retryTimes;
    }

    public boolean isIgnoreError() {
        return this.ignoreError;
    }

    public List<Chapter> getToc() {
        return this.toc;
    }

    public Novel getNovel() {
        return this.novel;
    }

    public String getUrl() {
        return this.url;
    }

    public int getTotalCount() {
        return this.totalCount;
    }

    public String getSavePath() {
        return this.savePath;
    }

    public IntConsumer getOnStateChange() {
        return this.onStateChange;
    }

    public void setNovelSpider(NovelSpider novelSpider) {
        this.novelSpider = novelSpider;
    }

    public void setThreadPool(ThreadPoolExecutor threadPool) {
        this.threadPool = threadPool;
    }

    public void setProgressChangeHandler(BiConsumer<Double, String> progressChangeHandler) {
        this.progressChangeHandler = progressChangeHandler;
    }

    public void setPipelines(List<Pipeline> pipelines) {
        this.pipelines = pipelines;
    }

    public void setTasks(CopyOnWriteArraySet<Task> tasks) {
        this.tasks = tasks;
    }

    public void setAnalyzerRule(AnalyzerRule analyzerRule) {
        this.analyzerRule = analyzerRule;
    }

    public void setCurrentTimes(int currentTimes) {
        this.currentTimes = currentTimes;
    }

    public void setRetryTimes(int retryTimes) {
        this.retryTimes = retryTimes;
    }

    public void setIgnoreError(boolean ignoreError) {
        this.ignoreError = ignoreError;
    }

    public void setToc(List<Chapter> toc) {
        this.toc = toc;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void setTotalCount(int totalCount) {
        this.totalCount = totalCount;
    }

    public void setSavePath(String savePath) {
        this.savePath = savePath;
    }

    public void setOnStateChange(IntConsumer onStateChange) {
        this.onStateChange = onStateChange;
    }

    public NovelSpider getNovelSpider() {
        return this.novelSpider;
    }

    class Task
    implements Runnable {
        private final Chapter chapter;
        private boolean canceled;

        public Task(Chapter chapter) {
            this.chapter = chapter;
            Spider.this.tasks.add(this);
        }

        @Override
        public void run() {
            try {
                this.assertNotCanceled();
                String content = Spider.this.novelSpider.content(this.chapter.getUrl());
                if (StringUtils.isBlank(content.trim()) && !"null".equals(content.trim())) {
                    throw new SpiderRuntimeException("\u672a\u77e5\u7684\uff0c\u672a\u6293\u53d6\u7684\u7ae0\u8282\u5185\u5bb9");
                }
                if (Boolean.TRUE.equals(Spider.this.analyzerRule.getContent().getRemoveTitle())) {
                    content = SpiderHelper.removeTitle(content, this.chapter.getName());
                }
                this.chapter.setContent(content);
                this.assertNotCanceled();
                if (CollectionUtils.isNotEmpty(Spider.this.pipelines)) {
                    Spider.this.pipelines.forEach(pipeline -> pipeline.process(this.chapter));
                }
                this.chapter.setContent(null);
                this.assertNotCanceled();
                if (this.chapter.getState() == ChapterState.FAILED) {
                    Spider.this.errorCount.decrementAndGet();
                }
                if (this.chapter.getState() != ChapterState.DOWNLOADED) {
                    Spider.this.successCount.incrementAndGet();
                    this.chapter.setState(ChapterState.DOWNLOADED);
                }
            }
            catch (Exception e) {
                if (e instanceof TaskCanceledException) {
                    return;
                }
                if (!this.isCanceled()) {
                    if (this.chapter.getState() != ChapterState.FAILED) {
                        this.chapter.setState(ChapterState.FAILED);
                        Spider.this.errorCount.incrementAndGet();
                    }
                    log.warn("\u5c0f\u8bf4\u7ae0\u8282\u5185\u5bb9\u722c\u53d6\u5931\u8d25\uff1aorder:{} - {} - {}", new Object[]{this.chapter.getOrder(), this.chapter.getName(), this.chapter.getUrl(), e});
                }
            }
            finally {
                Spider.this.tasks.remove(this);
                if (Spider.this.progressChangeHandler != null) {
                    Spider.this.progressChangeHandler.accept(Spider.this.progress(), Spider.this.progressText());
                }
                Long delayTime = Spider.this.analyzerRule.getContent().getDelayTime();
                if (!this.canceled && delayTime != null && delayTime > 0L) {
                    ThreadUtils.sleep(delayTime);
                }
            }
        }

        public void cancel() {
            this.canceled = true;
        }

        private boolean isCanceled() {
            return this.canceled || !Spider.this.isState(2) || this.chapter.getState() == ChapterState.DOWNLOADED;
        }

        private void assertNotCanceled() {
            if (this.isCanceled()) {
                throw new TaskCanceledException();
            }
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Task task = (Task)o;
            return this.chapter.getOrder() == task.chapter.getOrder();
        }

        public int hashCode() {
            return Objects.hash(this.chapter);
        }
    }
}

