/*
 * Decompiled with CFR 0.152.
 */
package com.unclezs.novel.analyzer.spider;

import com.unclezs.novel.analyzer.common.page.AbstractPageable;
import com.unclezs.novel.analyzer.core.NovelMatcher;
import com.unclezs.novel.analyzer.core.helper.DebugHelper;
import com.unclezs.novel.analyzer.core.model.AnalyzerRule;
import com.unclezs.novel.analyzer.model.Novel;
import com.unclezs.novel.analyzer.util.StringUtils;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SearchSpider
extends AbstractPageable<Novel> {
    private static final Logger log = LoggerFactory.getLogger(SearchSpider.class);
    private final List<AnalyzerRule> rules;
    private Consumer<List<Novel>> pageConsumer;
    private String keyword;

    public SearchSpider(List<AnalyzerRule> rules) {
        this.rules = rules;
    }

    public void search(String keyword) throws IOException {
        this.keyword = keyword;
        super.firstLoad();
    }

    @Override
    protected String getUniqueId(Novel item) {
        return item.getUrl();
    }

    @Override
    protected boolean loadPage(int page) {
        DebugHelper.debug("\u3010\u641c\u7d22\u3011\uff1a\u6b63\u5728\u641c\u7d22\u7b2c{}\u9875", page);
        boolean hasMore = false;
        for (AnalyzerRule rule : this.rules) {
            if (this.isVisited(rule.getSite())) continue;
            try {
                AtomicBoolean siteHasMore = new AtomicBoolean();
                List<Novel> novels = NovelMatcher.search(page, this.keyword, rule, novel -> {
                    if (!this.isCanceled()) {
                        if (DebugHelper.enabled() && StringUtils.isBlank(novel.getTitle())) {
                            return;
                        }
                        if (this.addItem(novel)) {
                            siteHasMore.set(true);
                        }
                    }
                });
                if (this.isCanceled()) break;
                if (siteHasMore.get()) {
                    log.trace("\u7ad9\u70b9:{} \u641c\u7d22\u7b2c{}\u9875\u5b8c\u6210 \u5173\u952e\u8bcd\uff1a\u300a{}\u300b\uff0c\u7ed3\u679c\u6570\u91cf\uff1a{}", new Object[]{rule.getSite(), page, this.keyword, novels.size()});
                    if (this.pageConsumer != null) {
                        this.pageConsumer.accept(novels);
                    }
                    hasMore = true;
                    continue;
                }
                this.addVisited(rule.getSite());
                log.trace("\u7ad9\u70b9:{} \u641c\u7d22\u7ed3\u675f \u5173\u952e\u8bcd\uff1a\u300a{}\u300b\uff0c\u5171{}\u9875", new Object[]{rule.getSite(), this.keyword, page - 1});
            }
            catch (IOException e) {
                this.addVisited(rule.getSite());
                log.warn("\u641c\u7d22\u5931\u8d25,page={},keyword={}\uff0c\u641c\u7d22\u89c4\u5219\uff1a{}", new Object[]{page, this.keyword, rule.getSearch(), e});
            }
        }
        return hasMore;
    }

    public void setPageConsumer(Consumer<List<Novel>> pageConsumer) {
        this.pageConsumer = pageConsumer;
    }

    public String getKeyword() {
        return this.keyword;
    }
}

