/*
 * Decompiled with CFR 0.152.
 */
package com.unclezs.novel.analyzer.spider;

import com.unclezs.novel.analyzer.model.Novel;
import com.unclezs.novel.analyzer.request.Http;
import com.unclezs.novel.analyzer.request.RequestParams;
import com.unclezs.novel.analyzer.util.uri.UrlEncoder;
import com.unclezs.novel.analyzer.util.uri.UrlUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.seimicrawler.xpath.JXDocument;
import org.seimicrawler.xpath.JXNode;

public class SearchEngines {
    public static final String BAIDU_SEARCH = "https://www.baidu.com/s?wd=";
    public static final String BAIDU_SEARCH_KEYWORD = "title: (\u9605\u8bfb \"%s\" (\u6700\u65b0\u7ae0\u8282) -(\u5b98\u65b9\u7f51\u7ad9))";
    public static final String BAIDU_SEARCH_COOKIE_PAGE_SIZE = "SL=0:NR=50:FG=1";

    public List<Novel> searchBaidu(String keyword) {
        String url = BAIDU_SEARCH + UrlEncoder.encode(String.format(BAIDU_SEARCH_KEYWORD, keyword));
        System.out.println(url);
        RequestParams params = RequestParams.create(url);
        params.addHeader("Cookie", BAIDU_SEARCH_COOKIE_PAGE_SIZE);
        String content = null;
        try {
            content = Http.content(params);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        List nodes = JXDocument.create((String)content).selN("//h3[@class='t']/a");
        ArrayList<Novel> novels = new ArrayList<Novel>(nodes.size() * 2);
        for (JXNode node : nodes) {
            String href = node.selOne("@href").asString();
            href = UrlUtils.getRedirectUrl(href);
            String title = node.selOne("allText()").asString().replace("...", "");
            Novel novel = new Novel();
            novel.setUrl(href);
            novel.setTitle(title);
            novels.add(novel);
        }
        return novels;
    }
}

