/*
 * Decompiled with CFR 0.152.
 */
package com.unclezs.novel.analyzer.script;

import com.unclezs.novel.analyzer.common.concurrent.ThreadContext;
import com.unclezs.novel.analyzer.util.CollectionUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.script.Bindings;
import javax.script.SimpleBindings;

public final class ScriptContext {
    public static final String VAR_URL = "url";
    public static final String VAR_SOURCE = "source";
    public static final String VAR_RESULT = "result";
    public static final String VAR_PARAMS = "params";
    private static final Set<String> VARIABLES = CollectionUtils.newSet("params", "url", "source", "result");
    private static final ThreadContext CONTEXT = new ThreadContext();

    public static void put(String key, Object value) {
        CONTEXT.put(key, value);
    }

    public static void remove(String ... keys) {
        Map<String, Object> map = CONTEXT.get();
        if (map != null && keys != null) {
            for (String key : keys) {
                map.remove(key);
            }
        }
    }

    public static Bindings current() {
        Map<String, Object> map = CONTEXT.get();
        if (map != null) {
            HashMap<String, Object> vars = new HashMap<String, Object>(map);
            for (String key : map.keySet()) {
                if (VARIABLES.contains(key)) continue;
                vars.remove(key);
            }
            return new SimpleBindings(vars);
        }
        return new SimpleBindings();
    }

    public static void remove() {
        CONTEXT.remove();
    }

    public static void removeIfEmpty() {
        Map<String, Object> map = CONTEXT.get();
        if (map != null && map.isEmpty()) {
            ScriptContext.remove();
        }
    }

    private ScriptContext() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

