/*
 * Decompiled with CFR 0.152.
 */
package com.unclezs.novel.analyzer.request.proxy;

import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Predicate;
import com.unclezs.novel.analyzer.common.concurrent.ThreadUtils;
import com.unclezs.novel.analyzer.request.Http;
import com.unclezs.novel.analyzer.request.RequestParams;
import com.unclezs.novel.analyzer.request.proxy.AbstractProxyProvider;
import com.unclezs.novel.analyzer.request.proxy.HttpProxy;
import com.unclezs.novel.analyzer.util.StringUtils;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultProxyProvider
extends AbstractProxyProvider {
    private static final Logger log = LoggerFactory.getLogger(DefaultProxyProvider.class);
    public static final int MAX_PROXY_NUMBER = 30;
    private static final String PROXY_SITE = "https://ip.jiangxianli.com/api/proxy_ips?page=1";
    private static final AtomicBoolean LOADING = new AtomicBoolean(false);

    public DefaultProxyProvider() {
        super(false, 30);
    }

    @Override
    public synchronized void loadProxy() {
        if (LOADING.get()) {
            return;
        }
        LOADING.set(true);
        ThreadUtils.execute(() -> {
            try {
                String json;
                String url = PROXY_SITE;
                do {
                    RequestParams requestParams = RequestParams.builder().url(url).autoProxy(false).enableProxy(false).build();
                    try {
                        json = Http.content(requestParams);
                    }
                    catch (IOException e) {
                        log.debug("\u4ee3\u7406\u7ad9\u70b9\u6293\u53d6\u5931\u8d25:{} \u505c\u6b62\u6293\u53d6\u4ee3\u7406", (Object)url, (Object)e);
                        LOADING.set(false);
                        return;
                    }
                    List ips = (List)JsonPath.read((String)json, (String)"$.data.data[*].ip", (Predicate[])new Predicate[0]);
                    List ports = (List)JsonPath.read((String)json, (String)"$.data.data[*].port", (Predicate[])new Predicate[0]);
                    for (int i = 0; i < ips.size(); ++i) {
                        int port;
                        String host = (String)ips.get(i);
                        HttpProxy proxy = new HttpProxy(host, port = Integer.parseInt((String)ports.get(i)));
                        if (this.verifyFailed(proxy)) continue;
                        boolean full = super.addProxy(proxy);
                        if (full) {
                            log.debug("\u6293\u53d6\u4ee3\u7406\u6570\u91cf\u8fbe\u5230\u4e0a\u9650\uff1a{}/{}", (Object)super.proxyNum(), (Object)30);
                            return;
                        }
                        log.debug("\u65b0\u6293\u53d6\u4ee3\u7406\uff1a{}:{}", (Object)host, (Object)port);
                    }
                } while (StringUtils.isNotEmpty(url = (String)JsonPath.read((String)json, (String)"$.data.next_page_url", (Predicate[])new Predicate[0])));
                log.info("\u5f53\u524d\u4ee3\u7406\u6c60\u4e2d\u4ee3\u7406\u603b\u6570\uff1a{}", (Object)this.proxyNum());
            }
            finally {
                LOADING.set(false);
            }
        });
        long start = System.currentTimeMillis();
        while (super.proxyNum() == 0) {
            if (System.currentTimeMillis() - start > 10000L) {
                return;
            }
            ThreadUtils.sleep(1000L);
        }
    }
}

