/*
 * Decompiled with CFR 0.152.
 */
package com.unclezs.novel.analyzer.request.proxy;

import com.unclezs.novel.analyzer.common.concurrent.ThreadUtils;
import com.unclezs.novel.analyzer.request.Http;
import com.unclezs.novel.analyzer.request.RequestParams;
import com.unclezs.novel.analyzer.request.proxy.HttpProxy;
import com.unclezs.novel.analyzer.request.spi.ProxyProvider;
import com.unclezs.novel.analyzer.util.RandomUtils;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractProxyProvider
implements ProxyProvider {
    private static final Logger log = LoggerFactory.getLogger(AbstractProxyProvider.class);
    private static final String VERIFY_URL = "http://httpbin.org/ip";
    private final Map<String, Integer> proxyPool = new HashMap<String, Integer>();
    private final LinkedList<String> index = new LinkedList();
    private boolean verify = false;
    private int maxProxyNumber = Integer.MAX_VALUE;

    protected AbstractProxyProvider() {
    }

    protected AbstractProxyProvider(boolean verify, int maxProxyNumber) {
        this.verify = verify;
        this.maxProxyNumber = maxProxyNumber;
    }

    public void setVerify(boolean verify) {
        this.verify = verify;
    }

    public boolean verifyFailed(HttpProxy proxy) {
        RequestParams requestParams = RequestParams.builder().url(VERIFY_URL).autoProxy(false).enableProxy(true).proxy(proxy).build();
        try {
            return !Http.content(requestParams).contains(proxy.getHost());
        }
        catch (IOException e) {
            log.trace("\u4ee3\u7406IP\u65e0\u6548,Host:{} - Port:{} - errorMsg:{}", new Object[]{proxy.getHost(), proxy.getPort(), e.getMessage()});
            return true;
        }
    }

    public abstract void loadProxy();

    public void reset() {
        this.proxyPool.clear();
        this.index.clear();
    }

    @Override
    public HttpProxy getProxy() {
        if (this.index.isEmpty()) {
            this.loadProxy();
        }
        return this.verify ? this.randomVerifiedProxy() : this.randomProxy();
    }

    public HttpProxy randomProxy() {
        if (this.proxyPool.isEmpty()) {
            return HttpProxy.NO_PROXY;
        }
        int randomInt = RandomUtils.randomInt(this.index.size());
        String host = this.index.get(randomInt);
        return new HttpProxy(host, this.proxyPool.get(host));
    }

    public HttpProxy randomVerifiedProxy() {
        HttpProxy verifiedProxy = this.randomProxy();
        while (this.verifyFailed(verifiedProxy)) {
            this.removeProxy(verifiedProxy.getHost());
            verifiedProxy = this.randomProxy();
        }
        return verifiedProxy;
    }

    @Override
    public void removeProxy(HttpProxy proxy) {
        if (this.index.isEmpty()) {
            return;
        }
        CleanThreadPoolHolder.EXECUTOR.execute(() -> {
            if (this.verifyFailed(proxy)) {
                this.removeProxy(proxy.getHost());
            }
        });
    }

    public void removeProxy(String host) {
        if (this.index.isEmpty()) {
            return;
        }
        this.index.remove(host);
        this.proxyPool.remove(host);
    }

    public int proxyNum() {
        return this.index.size();
    }

    public boolean addProxy(String host, Integer port) {
        if (this.index.size() < this.maxProxyNumber && !this.proxyPool.containsKey(host)) {
            this.proxyPool.put(host, port);
            this.index.add(host);
        }
        return this.index.size() >= this.maxProxyNumber;
    }

    public boolean addProxy(HttpProxy proxy) {
        return this.addProxy(proxy.getHost(), proxy.getPort());
    }

    static class CleanThreadPoolHolder {
        public static final ExecutorService EXECUTOR = ThreadUtils.newSingleThreadExecutor("clean_proxy");

        private CleanThreadPoolHolder() {
        }
    }
}

