/*
 * Decompiled with CFR 0.152.
 */
package com.unclezs.novel.analyzer.request.phantomjs;

import com.unclezs.novel.analyzer.request.RequestParams;
import com.unclezs.novel.analyzer.request.phantomjs.PhantomJsRequestParams;
import com.unclezs.novel.analyzer.request.spi.HttpProvider;
import com.unclezs.novel.analyzer.util.CommandUtils;
import com.unclezs.novel.analyzer.util.FileUtils;
import com.unclezs.novel.analyzer.util.StringUtils;
import com.unclezs.novel.analyzer.util.SystemUtils;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PhantomJsClient
implements HttpProvider {
    private static final Logger log = LoggerFactory.getLogger(PhantomJsClient.class);
    public static final String PHANTOMJS_PATH = "phantomjs.path";
    public static final String PHANTOMJS_SCRIPT = "phantomjs.script.path";
    public static final String DEFAULT_PHANTOMJS_SCRIPT = FileUtils.USER_DIR + "/script/spider.js";
    public static final String DEFAULT_PHANTOMJS_PATH = FileUtils.USER_DIR + "/script/phantomjs" + SystemUtils.getExecuteSuffix();

    @Override
    public String content(RequestParams data) throws IOException {
        return this.executePhantomJs(PhantomJsRequestParams.from(data));
    }

    @Override
    public byte[] bytes(RequestParams requestParams) throws IOException {
        throw new UnsupportedEncodingException("PhantomJs\u52a8\u6001\u7f51\u9875HTTP\u5ba2\u6237\u7aef\u4e0d\u652f\u6301\u83b7\u53d6\u6d41");
    }

    @Override
    public boolean isDynamic() {
        return true;
    }

    public String content(String url) throws IOException {
        return this.content(RequestParams.create(url));
    }

    public String executePhantomJs(PhantomJsRequestParams data) throws IOException {
        if (StringUtils.isEmpty(data.getUrl())) {
            log.warn("phantomJS com.unclezs.novel.analyzer.request url \u4e0d\u80fd\u4e3a\u7a7a");
            return "";
        }
        StringBuilder command = new StringBuilder();
        command.append(System.getProperty(PHANTOMJS_PATH, DEFAULT_PHANTOMJS_PATH));
        command.append(" ").append("--ignore-ssl-errors=").append(data.isIgnoreSslError());
        command.append(" ").append("--load-images=").append(data.isLoadImg());
        if (StringUtils.isNotEmpty(data.getProxy())) {
            command.append(" ").append("--proxy=").append(data.getProxy());
        }
        command.append(" ").append(System.getProperty(PHANTOMJS_SCRIPT, DEFAULT_PHANTOMJS_SCRIPT));
        command.append(" ").append("\"").append(data.getUrl()).append("\"");
        command.append(" ").append("\"").append(data.getReferer()).append("\"");
        command.append(" ").append("\"").append(data.getCookie()).append("\"");
        command.append(" ").append("\"").append(data.getUserAgent()).append("\"");
        return CommandUtils.execute(command.toString());
    }
}

