/*
 * Decompiled with CFR 0.152.
 */
package com.unclezs.novel.analyzer.request;

import com.unclezs.novel.analyzer.core.model.Params;
import com.unclezs.novel.analyzer.model.Verifiable;
import com.unclezs.novel.analyzer.request.HttpMethod;
import com.unclezs.novel.analyzer.request.MediaType;
import com.unclezs.novel.analyzer.request.proxy.HttpProxy;
import com.unclezs.novel.analyzer.util.CollectionUtils;
import com.unclezs.novel.analyzer.util.SerializationUtils;
import com.unclezs.novel.analyzer.util.StringUtils;
import com.unclezs.novel.analyzer.util.uri.UrlUtils;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequestParams
implements Verifiable,
Serializable {
    private static final Logger log = LoggerFactory.getLogger(RequestParams.class);
    public static final String REFERER = "Referer";
    public static final String AUTO_REFERER = "auto";
    public static final String COOKIE = "Cookie";
    public static final String USER_AGENT = "User-Agent";
    public static final String USER_AGENT_DEFAULT_VALUE = "Mozilla/5.0 (Macintosh; Intel Mac OS X 11_0_1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/87.0.4280.88 Safari/537.36";
    public static final String HEADER_SEPARATOR = ": ";
    private static final long serialVersionUID = 5277637191594804618L;
    private String url;
    private String method;
    private String charset;
    private Map<String, String> headers;
    private String mediaType;
    private String body;
    private String urlParams;
    private Boolean dynamic;
    private HttpProxy proxy;
    private Boolean enableProxy;
    private Boolean autoProxy;
    private String script;
    private Long dynamicDelayTime = 500L;

    public static RequestParams create(String url) {
        return RequestParams.builder().url(url).build();
    }

    public static RequestParams create(String url, RequestParams params) {
        params = params == null ? new RequestParams() : params.copy();
        params.setUrl(url);
        return params;
    }

    public String getMethod() {
        return StringUtils.isNotEmpty(this.method) ? this.method.toUpperCase() : HttpMethod.GET.name();
    }

    public boolean isEnableProxy() {
        if (this.proxy == null || this.proxy == HttpProxy.NO_PROXY) {
            return false;
        }
        return Boolean.TRUE.equals(this.enableProxy);
    }

    public String getMediaType() {
        if (StringUtils.isNotBlank(this.mediaType)) {
            if (MediaType.FORM.name().equalsIgnoreCase(this.mediaType)) {
                return MediaType.FORM.getMediaType();
            }
            if (MediaType.JSON.name().equalsIgnoreCase(this.mediaType)) {
                return MediaType.JSON.getMediaType();
            }
        }
        return this.mediaType;
    }

    public RequestParams copy() {
        return SerializationUtils.deepClone(this);
    }

    public String getHeader(String headerName, String defaultName) {
        if (CollectionUtils.isNotEmpty(this.headers)) {
            return this.headers.getOrDefault(headerName, defaultName);
        }
        return defaultName;
    }

    public String getHeader(String headerName) {
        if (CollectionUtils.isNotEmpty(this.headers)) {
            return this.headers.get(headerName);
        }
        return null;
    }

    public void setHeader(String headerName, String headerValue) {
        if (this.headers == null) {
            this.headers = new HashMap<String, String>(8);
        }
        this.headers.put(headerName, headerValue);
    }

    public void addHeader(String headerName, String headerValue) {
        if (this.headers == null) {
            this.headers = new HashMap<String, String>(8);
            this.headers.put(headerName, headerValue);
        } else {
            this.headers.putIfAbsent(headerName, headerValue);
        }
    }

    public String getHeaderString() {
        if (this.headers == null) {
            return null;
        }
        StringBuilder headersStr = new StringBuilder();
        this.headers.forEach((key, value) -> headersStr.append((String)key).append(HEADER_SEPARATOR).append((String)value).append("\n"));
        return headersStr.toString();
    }

    public void setHeaderString(String headersString) {
        String[] headerLines;
        if (StringUtils.isBlank(headersString) && this.headers != null) {
            this.headers.clear();
            return;
        }
        for (String headerLine : headerLines = headersString.split("\n")) {
            if (headerLine.contains(HEADER_SEPARATOR) && !headerLine.endsWith(HEADER_SEPARATOR)) continue;
            return;
        }
        this.headers = new HashMap<String, String>(16);
        for (String headerLine : headerLines) {
            String[] split = headerLine.split(HEADER_SEPARATOR);
            this.headers.put(split[0], split[1]);
        }
    }

    public void overrideParams(Params params) {
        if (params == null) {
            return;
        }
        if (StringUtils.isNotBlank(params.getCookie()) && this.getHeader(COOKIE) == null) {
            this.setHeader(COOKIE, params.getCookie());
        }
        if (StringUtils.isNotBlank(params.getUserAgent()) && this.getHeader(USER_AGENT) == null) {
            this.setHeader(USER_AGENT, params.getUserAgent());
        }
        if (Boolean.TRUE.equals(params.getDynamic())) {
            this.setDynamic(true);
        }
        if (Boolean.TRUE.equals(params.getAutoReferer())) {
            this.addHeader(REFERER, AUTO_REFERER);
        }
        if (Boolean.TRUE.equals(params.getEnabledProxy())) {
            this.setEnableProxy(true);
        }
    }

    @Override
    public boolean isEffective() {
        return UrlUtils.isHttpUrl(this.url);
    }

    public static RequestParamsBuilder builder() {
        return new RequestParamsBuilder();
    }

    public String getUrl() {
        return this.url;
    }

    public String getCharset() {
        return this.charset;
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public String getBody() {
        return this.body;
    }

    public String getUrlParams() {
        return this.urlParams;
    }

    public Boolean getDynamic() {
        return this.dynamic;
    }

    public HttpProxy getProxy() {
        return this.proxy;
    }

    public Boolean getEnableProxy() {
        return this.enableProxy;
    }

    public Boolean getAutoProxy() {
        return this.autoProxy;
    }

    public String getScript() {
        return this.script;
    }

    public Long getDynamicDelayTime() {
        return this.dynamicDelayTime;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public void setCharset(String charset) {
        this.charset = charset;
    }

    public void setHeaders(Map<String, String> headers) {
        this.headers = headers;
    }

    public void setMediaType(String mediaType) {
        this.mediaType = mediaType;
    }

    public void setBody(String body) {
        this.body = body;
    }

    public void setUrlParams(String urlParams) {
        this.urlParams = urlParams;
    }

    public void setDynamic(Boolean dynamic) {
        this.dynamic = dynamic;
    }

    public void setProxy(HttpProxy proxy) {
        this.proxy = proxy;
    }

    public void setEnableProxy(Boolean enableProxy) {
        this.enableProxy = enableProxy;
    }

    public void setAutoProxy(Boolean autoProxy) {
        this.autoProxy = autoProxy;
    }

    public void setScript(String script) {
        this.script = script;
    }

    public void setDynamicDelayTime(Long dynamicDelayTime) {
        this.dynamicDelayTime = dynamicDelayTime;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RequestParams)) {
            return false;
        }
        RequestParams other = (RequestParams)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$dynamic = this.getDynamic();
        Boolean other$dynamic = other.getDynamic();
        if (this$dynamic == null ? other$dynamic != null : !((Object)this$dynamic).equals(other$dynamic)) {
            return false;
        }
        Boolean this$enableProxy = this.getEnableProxy();
        Boolean other$enableProxy = other.getEnableProxy();
        if (this$enableProxy == null ? other$enableProxy != null : !((Object)this$enableProxy).equals(other$enableProxy)) {
            return false;
        }
        Boolean this$autoProxy = this.getAutoProxy();
        Boolean other$autoProxy = other.getAutoProxy();
        if (this$autoProxy == null ? other$autoProxy != null : !((Object)this$autoProxy).equals(other$autoProxy)) {
            return false;
        }
        Long this$dynamicDelayTime = this.getDynamicDelayTime();
        Long other$dynamicDelayTime = other.getDynamicDelayTime();
        if (this$dynamicDelayTime == null ? other$dynamicDelayTime != null : !((Object)this$dynamicDelayTime).equals(other$dynamicDelayTime)) {
            return false;
        }
        String this$url = this.getUrl();
        String other$url = other.getUrl();
        if (this$url == null ? other$url != null : !this$url.equals(other$url)) {
            return false;
        }
        String this$method = this.getMethod();
        String other$method = other.getMethod();
        if (this$method == null ? other$method != null : !this$method.equals(other$method)) {
            return false;
        }
        String this$charset = this.getCharset();
        String other$charset = other.getCharset();
        if (this$charset == null ? other$charset != null : !this$charset.equals(other$charset)) {
            return false;
        }
        Map<String, String> this$headers = this.getHeaders();
        Map<String, String> other$headers = other.getHeaders();
        if (this$headers == null ? other$headers != null : !((Object)this$headers).equals(other$headers)) {
            return false;
        }
        String this$mediaType = this.getMediaType();
        String other$mediaType = other.getMediaType();
        if (this$mediaType == null ? other$mediaType != null : !this$mediaType.equals(other$mediaType)) {
            return false;
        }
        String this$body = this.getBody();
        String other$body = other.getBody();
        if (this$body == null ? other$body != null : !this$body.equals(other$body)) {
            return false;
        }
        String this$urlParams = this.getUrlParams();
        String other$urlParams = other.getUrlParams();
        if (this$urlParams == null ? other$urlParams != null : !this$urlParams.equals(other$urlParams)) {
            return false;
        }
        HttpProxy this$proxy = this.getProxy();
        HttpProxy other$proxy = other.getProxy();
        if (this$proxy == null ? other$proxy != null : !((Object)this$proxy).equals(other$proxy)) {
            return false;
        }
        String this$script = this.getScript();
        String other$script = other.getScript();
        return !(this$script == null ? other$script != null : !this$script.equals(other$script));
    }

    protected boolean canEqual(Object other) {
        return other instanceof RequestParams;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $dynamic = this.getDynamic();
        result = result * 59 + ($dynamic == null ? 43 : ((Object)$dynamic).hashCode());
        Boolean $enableProxy = this.getEnableProxy();
        result = result * 59 + ($enableProxy == null ? 43 : ((Object)$enableProxy).hashCode());
        Boolean $autoProxy = this.getAutoProxy();
        result = result * 59 + ($autoProxy == null ? 43 : ((Object)$autoProxy).hashCode());
        Long $dynamicDelayTime = this.getDynamicDelayTime();
        result = result * 59 + ($dynamicDelayTime == null ? 43 : ((Object)$dynamicDelayTime).hashCode());
        String $url = this.getUrl();
        result = result * 59 + ($url == null ? 43 : $url.hashCode());
        String $method = this.getMethod();
        result = result * 59 + ($method == null ? 43 : $method.hashCode());
        String $charset = this.getCharset();
        result = result * 59 + ($charset == null ? 43 : $charset.hashCode());
        Map<String, String> $headers = this.getHeaders();
        result = result * 59 + ($headers == null ? 43 : ((Object)$headers).hashCode());
        String $mediaType = this.getMediaType();
        result = result * 59 + ($mediaType == null ? 43 : $mediaType.hashCode());
        String $body = this.getBody();
        result = result * 59 + ($body == null ? 43 : $body.hashCode());
        String $urlParams = this.getUrlParams();
        result = result * 59 + ($urlParams == null ? 43 : $urlParams.hashCode());
        HttpProxy $proxy = this.getProxy();
        result = result * 59 + ($proxy == null ? 43 : ((Object)$proxy).hashCode());
        String $script = this.getScript();
        result = result * 59 + ($script == null ? 43 : $script.hashCode());
        return result;
    }

    public String toString() {
        return "RequestParams(url=" + this.getUrl() + ", method=" + this.getMethod() + ", charset=" + this.getCharset() + ", headers=" + this.getHeaders() + ", mediaType=" + this.getMediaType() + ", body=" + this.getBody() + ", urlParams=" + this.getUrlParams() + ", dynamic=" + this.getDynamic() + ", proxy=" + this.getProxy() + ", enableProxy=" + this.getEnableProxy() + ", autoProxy=" + this.getAutoProxy() + ", script=" + this.getScript() + ", dynamicDelayTime=" + this.getDynamicDelayTime() + ")";
    }

    public RequestParams(String url, String method, String charset, Map<String, String> headers, String mediaType, String body, String urlParams, Boolean dynamic, HttpProxy proxy, Boolean enableProxy, Boolean autoProxy, String script, Long dynamicDelayTime) {
        this.url = url;
        this.method = method;
        this.charset = charset;
        this.headers = headers;
        this.mediaType = mediaType;
        this.body = body;
        this.urlParams = urlParams;
        this.dynamic = dynamic;
        this.proxy = proxy;
        this.enableProxy = enableProxy;
        this.autoProxy = autoProxy;
        this.script = script;
        this.dynamicDelayTime = dynamicDelayTime;
    }

    public RequestParams() {
    }

    public static class RequestParamsBuilder {
        private String url;
        private String method;
        private String charset;
        private Map<String, String> headers;
        private String mediaType;
        private String body;
        private String urlParams;
        private Boolean dynamic;
        private HttpProxy proxy;
        private Boolean enableProxy;
        private Boolean autoProxy;
        private String script;
        private Long dynamicDelayTime;

        RequestParamsBuilder() {
        }

        public RequestParamsBuilder url(String url) {
            this.url = url;
            return this;
        }

        public RequestParamsBuilder method(String method) {
            this.method = method;
            return this;
        }

        public RequestParamsBuilder charset(String charset) {
            this.charset = charset;
            return this;
        }

        public RequestParamsBuilder headers(Map<String, String> headers) {
            this.headers = headers;
            return this;
        }

        public RequestParamsBuilder mediaType(String mediaType) {
            this.mediaType = mediaType;
            return this;
        }

        public RequestParamsBuilder body(String body) {
            this.body = body;
            return this;
        }

        public RequestParamsBuilder urlParams(String urlParams) {
            this.urlParams = urlParams;
            return this;
        }

        public RequestParamsBuilder dynamic(Boolean dynamic) {
            this.dynamic = dynamic;
            return this;
        }

        public RequestParamsBuilder proxy(HttpProxy proxy) {
            this.proxy = proxy;
            return this;
        }

        public RequestParamsBuilder enableProxy(Boolean enableProxy) {
            this.enableProxy = enableProxy;
            return this;
        }

        public RequestParamsBuilder autoProxy(Boolean autoProxy) {
            this.autoProxy = autoProxy;
            return this;
        }

        public RequestParamsBuilder script(String script) {
            this.script = script;
            return this;
        }

        public RequestParamsBuilder dynamicDelayTime(Long dynamicDelayTime) {
            this.dynamicDelayTime = dynamicDelayTime;
            return this;
        }

        public RequestParams build() {
            return new RequestParams(this.url, this.method, this.charset, this.headers, this.mediaType, this.body, this.urlParams, this.dynamic, this.proxy, this.enableProxy, this.autoProxy, this.script, this.dynamicDelayTime);
        }

        public String toString() {
            return "RequestParams.RequestParamsBuilder(url=" + this.url + ", method=" + this.method + ", charset=" + this.charset + ", headers=" + this.headers + ", mediaType=" + this.mediaType + ", body=" + this.body + ", urlParams=" + this.urlParams + ", dynamic=" + this.dynamic + ", proxy=" + this.proxy + ", enableProxy=" + this.enableProxy + ", autoProxy=" + this.autoProxy + ", script=" + this.script + ", dynamicDelayTime=" + this.dynamicDelayTime + ")";
        }
    }
}

