/*
 * Decompiled with CFR 0.152.
 */
package com.unclezs.novel.analyzer.model;

import com.unclezs.novel.analyzer.model.ChapterState;
import java.io.Serializable;
import java.util.Objects;

public class Chapter
implements Serializable {
    private int order = -1;
    private String name;
    private String url;
    private String content;
    private Long from;
    private Long to;
    private ChapterState state = ChapterState.INIT;

    public Chapter(String name, String url) {
        this.name = name;
        this.url = url;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Chapter chapter = (Chapter)o;
        return Objects.equals(this.url, chapter.url);
    }

    public int hashCode() {
        return Objects.hash(this.url);
    }

    public String toString() {
        return String.format("name=%s,url=%s", this.name, this.url);
    }

    public boolean downloaded() {
        return this.state == ChapterState.DOWNLOADED;
    }

    public int getOrder() {
        return this.order;
    }

    public String getName() {
        return this.name;
    }

    public String getUrl() {
        return this.url;
    }

    public String getContent() {
        return this.content;
    }

    public Long getFrom() {
        return this.from;
    }

    public Long getTo() {
        return this.to;
    }

    public ChapterState getState() {
        return this.state;
    }

    public void setOrder(int order) {
        this.order = order;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public void setFrom(Long from) {
        this.from = from;
    }

    public void setTo(Long to) {
        this.to = to;
    }

    public void setState(ChapterState state) {
        this.state = state;
    }

    public Chapter() {
    }

    public Chapter(int order, String name, String url, String content, Long from, Long to, ChapterState state) {
        this.order = order;
        this.name = name;
        this.url = url;
        this.content = content;
        this.from = from;
        this.to = to;
        this.state = state;
    }
}

