/*
 * Decompiled with CFR 0.152.
 */
package com.unclezs.novel.analyzer.core.rule;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.unclezs.novel.analyzer.core.helper.RuleHelper;
import com.unclezs.novel.analyzer.core.matcher.MatcherManager;
import com.unclezs.novel.analyzer.core.rule.ReplaceRule;
import com.unclezs.novel.analyzer.model.Pair;
import com.unclezs.novel.analyzer.util.CollectionUtils;
import com.unclezs.novel.analyzer.util.GsonUtils;
import com.unclezs.novel.analyzer.util.StringUtils;
import java.io.Serializable;
import java.lang.reflect.Type;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Supplier;

public class CommonRule
implements Serializable,
JsonDeserializer<CommonRule>,
JsonSerializer<CommonRule> {
    private static final long serialVersionUID = 6752071448939164168L;
    private String page;
    private String type;
    private String rule;
    private String script;
    private Set<ReplaceRule> replace;

    public static boolean isEffective(CommonRule commonRule) {
        return commonRule != null && (commonRule.isEffective() || StringUtils.isNotBlank(commonRule.getScript()));
    }

    public static boolean isEffective(CommonRule ... commonRules) {
        if (commonRules == null) {
            return false;
        }
        for (CommonRule commonRule : commonRules) {
            if (CommonRule.isEffective(commonRule)) continue;
            return false;
        }
        return true;
    }

    public static boolean isEffectiveOnlyScript(CommonRule commonRule) {
        return commonRule != null && !commonRule.isEffective() && StringUtils.isNotBlank(commonRule.getScript());
    }

    public static boolean hasRule(CommonRule commonRule) {
        return commonRule != null && StringUtils.isNotBlank(commonRule.getRule()) && MatcherManager.getMatcher(commonRule.getRule()) == null;
    }

    public static CommonRule create(String type, String rule) {
        CommonRule commonRule = new CommonRule();
        commonRule.setRule(rule);
        commonRule.setType(type);
        return commonRule;
    }

    public static CommonRule create(String withTypeRule) {
        Pair<String, String> ruleType = RuleHelper.parseRuleType(withTypeRule);
        CommonRule commonRule = new CommonRule();
        commonRule.setType(ruleType.getLeft());
        commonRule.setRule(ruleType.getRight());
        return commonRule;
    }

    public static Supplier<String> ruleStringGetter(CommonRule rule) {
        return () -> {
            if (rule == null) {
                return null;
            }
            return rule.ruleString();
        };
    }

    public static Consumer<String> ruleStringSetter(CommonRule rule) {
        return ruleString -> {
            if (rule != null) {
                rule.setRuleString((String)ruleString);
            }
        };
    }

    public void addReplaceRule(ReplaceRule rule) {
        if (this.replace == null) {
            this.replace = new HashSet<ReplaceRule>();
        }
        this.replace.remove(rule);
        this.replace.add(rule);
    }

    public boolean isEffective() {
        return StringUtils.isNotBlank(this.type) && StringUtils.isNotBlank(this.rule) && MatcherManager.getMatcher(this.rule) == null;
    }

    public String ruleString() {
        if (StringUtils.isBlank(this.type) || this.rule != null && this.rule.startsWith(this.type)) {
            return this.rule;
        }
        StringBuilder result = new StringBuilder();
        result.append(this.type);
        if (!this.type.endsWith(":") && !MatcherManager.isDefaultAlias(this.type)) {
            result.append(":");
        }
        if (StringUtils.isNotBlank(this.rule)) {
            result.append(this.rule);
        }
        return result.toString();
    }

    public void setRuleString(String ruleString) {
        Pair<String, String> pair = RuleHelper.parseRuleType(ruleString);
        if (pair != null) {
            this.type = pair.getLeft();
            this.rule = pair.getRight();
        } else {
            this.rule = ruleString;
            this.type = null;
        }
    }

    public CommonRule deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        if (typeOfT != CommonRule.class) {
            return null;
        }
        CommonRule commonRule = new CommonRule();
        if (json.isJsonObject()) {
            JsonObject ruleJson = json.getAsJsonObject();
            commonRule.setPage(GsonUtils.getOrDefault(ruleJson, "page", null));
            commonRule.setType(GsonUtils.getOrDefault(ruleJson, "type", null));
            commonRule.setRule(GsonUtils.getOrDefault(ruleJson, "rule", null));
            commonRule.setScript(GsonUtils.getOrDefault(ruleJson, "script", null));
            JsonElement purifyRulesJsonElement = ruleJson.get("replace");
            if (purifyRulesJsonElement != null) {
                commonRule.setReplace(this.handlePurifyRule(purifyRulesJsonElement, context));
            }
        } else {
            String ruleValue = json.getAsString();
            if (StringUtils.isNotEmpty(ruleValue)) {
                commonRule.setRule(ruleValue);
            }
        }
        if (StringUtils.isNotEmpty(commonRule.getRule())) {
            Pair<String, String> rulePair = RuleHelper.parseRuleType(commonRule.getRule());
            if (rulePair != null) {
                if (StringUtils.isNotEmpty(rulePair.getLeft()) && StringUtils.isEmpty(commonRule.getType())) {
                    commonRule.setType(rulePair.getLeft());
                }
                if (StringUtils.isNotEmpty(rulePair.getRight())) {
                    commonRule.setRule(rulePair.getRight());
                }
            }
        } else {
            commonRule.setType(null);
            commonRule.setRule(null);
        }
        if (StringUtils.isNotBlank(commonRule.rule) && MatcherManager.getMatcher(commonRule.rule) != null) {
            commonRule.setRule(null);
            commonRule.setType(null);
        }
        return commonRule;
    }

    private Set<ReplaceRule> handlePurifyRule(JsonElement purifyRulesJsonElement, JsonDeserializationContext context) {
        HashSet<ReplaceRule> replaceRules = new HashSet<ReplaceRule>();
        if (purifyRulesJsonElement.isJsonObject()) {
            ReplaceRule replaceRule = (ReplaceRule)context.deserialize(purifyRulesJsonElement, ReplaceRule.class);
            if (replaceRule != null) {
                replaceRules.add(replaceRule);
            }
        } else if (purifyRulesJsonElement.isJsonArray()) {
            JsonArray purifyRulesJsonElementAsJsonArray = purifyRulesJsonElement.getAsJsonArray();
            for (JsonElement element : purifyRulesJsonElementAsJsonArray) {
                if (element.isJsonObject()) {
                    ReplaceRule replaceRule = (ReplaceRule)context.deserialize(element, ReplaceRule.class);
                    if (replaceRule == null) continue;
                    replaceRules.add(replaceRule);
                    continue;
                }
                String purifyRuleStr = element.getAsString();
                if (!StringUtils.isNotEmpty(purifyRuleStr)) continue;
                replaceRules.add(ReplaceRule.parseRule(purifyRuleStr));
            }
        } else {
            String purifyRuleStr = purifyRulesJsonElement.getAsString();
            if (StringUtils.isNotEmpty(purifyRuleStr)) {
                replaceRules.add(ReplaceRule.parseRule(purifyRuleStr));
            }
        }
        return replaceRules;
    }

    public JsonElement serialize(CommonRule commonRule, Type type, JsonSerializationContext jsonSerializationContext) {
        boolean hasReplace = CollectionUtils.isNotEmpty(commonRule.replace);
        boolean hasScript = StringUtils.isNotBlank(commonRule.script);
        boolean hasPage = StringUtils.isNotBlank(commonRule.page);
        JsonObject jsonObject = new JsonObject();
        if (!(hasPage || hasReplace || hasScript)) {
            String ruleString = commonRule.ruleString();
            if (ruleString == null) {
                return null;
            }
            return new JsonPrimitive(commonRule.ruleString());
        }
        if (StringUtils.isNotBlank(commonRule.ruleString())) {
            jsonObject.addProperty("rule", commonRule.ruleString());
        }
        if (hasReplace && commonRule.replace.size() == 1) {
            String value = StringUtils.removeQuote(RuleHelper.GSON.toJson((Object)commonRule.replace.iterator().next()));
            value = value.replace("\\\\", "\\");
            jsonObject.addProperty("replace", value);
        } else if (hasReplace) {
            jsonObject.add("replace", RuleHelper.GSON.toJsonTree(commonRule.replace));
        }
        if (hasPage) {
            jsonObject.addProperty("page", commonRule.page);
        }
        if (hasScript) {
            jsonObject.addProperty("script", commonRule.script);
        }
        return jsonObject;
    }

    public String getPage() {
        return this.page;
    }

    public String getType() {
        return this.type;
    }

    public String getRule() {
        return this.rule;
    }

    public String getScript() {
        return this.script;
    }

    public Set<ReplaceRule> getReplace() {
        return this.replace;
    }

    public void setPage(String page) {
        this.page = page;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setRule(String rule) {
        this.rule = rule;
    }

    public void setScript(String script) {
        this.script = script;
    }

    public void setReplace(Set<ReplaceRule> replace) {
        this.replace = replace;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CommonRule)) {
            return false;
        }
        CommonRule other = (CommonRule)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$page = this.getPage();
        String other$page = other.getPage();
        if (this$page == null ? other$page != null : !this$page.equals(other$page)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        String this$rule = this.getRule();
        String other$rule = other.getRule();
        if (this$rule == null ? other$rule != null : !this$rule.equals(other$rule)) {
            return false;
        }
        String this$script = this.getScript();
        String other$script = other.getScript();
        if (this$script == null ? other$script != null : !this$script.equals(other$script)) {
            return false;
        }
        Set<ReplaceRule> this$replace = this.getReplace();
        Set<ReplaceRule> other$replace = other.getReplace();
        return !(this$replace == null ? other$replace != null : !((Object)this$replace).equals(other$replace));
    }

    protected boolean canEqual(Object other) {
        return other instanceof CommonRule;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $page = this.getPage();
        result = result * 59 + ($page == null ? 43 : $page.hashCode());
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        String $rule = this.getRule();
        result = result * 59 + ($rule == null ? 43 : $rule.hashCode());
        String $script = this.getScript();
        result = result * 59 + ($script == null ? 43 : $script.hashCode());
        Set<ReplaceRule> $replace = this.getReplace();
        result = result * 59 + ($replace == null ? 43 : ((Object)$replace).hashCode());
        return result;
    }

    public String toString() {
        return "CommonRule(page=" + this.getPage() + ", type=" + this.getType() + ", rule=" + this.getRule() + ", script=" + this.getScript() + ", replace=" + this.getReplace() + ")";
    }
}

