/*
 * Decompiled with CFR 0.152.
 */
package com.unclezs.novel.analyzer.core.model;

import com.unclezs.novel.analyzer.core.model.ContentRule;
import com.unclezs.novel.analyzer.core.model.DetailRule;
import com.unclezs.novel.analyzer.core.model.Params;
import com.unclezs.novel.analyzer.core.model.SearchRule;
import com.unclezs.novel.analyzer.core.model.TocRule;
import com.unclezs.novel.analyzer.model.Verifiable;
import com.unclezs.novel.analyzer.util.SerializationUtils;
import com.unclezs.novel.analyzer.util.uri.UrlUtils;
import java.io.Serializable;

public class AnalyzerRule
implements Serializable,
Verifiable {
    private static final long serialVersionUID = -5141682318667696007L;
    private String name;
    private String site;
    private String group;
    private Boolean enabled = true;
    private Boolean audio = false;
    private int weight = 0;
    private Params params = new Params();
    private ContentRule content = new ContentRule();
    private TocRule toc = new TocRule();
    private DetailRule detail = new DetailRule();
    private SearchRule search = new SearchRule();

    @Override
    public boolean isEffective() {
        return UrlUtils.isHttpUrl(this.site);
    }

    public AnalyzerRule copy() {
        return SerializationUtils.deepClone(this);
    }

    public String getName() {
        return this.name;
    }

    public String getSite() {
        return this.site;
    }

    public String getGroup() {
        return this.group;
    }

    public Boolean getEnabled() {
        return this.enabled;
    }

    public Boolean getAudio() {
        return this.audio;
    }

    public int getWeight() {
        return this.weight;
    }

    public Params getParams() {
        return this.params;
    }

    public ContentRule getContent() {
        return this.content;
    }

    public TocRule getToc() {
        return this.toc;
    }

    public DetailRule getDetail() {
        return this.detail;
    }

    public SearchRule getSearch() {
        return this.search;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setSite(String site) {
        this.site = site;
    }

    public void setGroup(String group) {
        this.group = group;
    }

    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    public void setAudio(Boolean audio) {
        this.audio = audio;
    }

    public void setWeight(int weight) {
        this.weight = weight;
    }

    public void setParams(Params params) {
        this.params = params;
    }

    public void setContent(ContentRule content) {
        this.content = content;
    }

    public void setToc(TocRule toc) {
        this.toc = toc;
    }

    public void setDetail(DetailRule detail) {
        this.detail = detail;
    }

    public void setSearch(SearchRule search) {
        this.search = search;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AnalyzerRule)) {
            return false;
        }
        AnalyzerRule other = (AnalyzerRule)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getWeight() != other.getWeight()) {
            return false;
        }
        Boolean this$enabled = this.getEnabled();
        Boolean other$enabled = other.getEnabled();
        if (this$enabled == null ? other$enabled != null : !((Object)this$enabled).equals(other$enabled)) {
            return false;
        }
        Boolean this$audio = this.getAudio();
        Boolean other$audio = other.getAudio();
        if (this$audio == null ? other$audio != null : !((Object)this$audio).equals(other$audio)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$site = this.getSite();
        String other$site = other.getSite();
        if (this$site == null ? other$site != null : !this$site.equals(other$site)) {
            return false;
        }
        String this$group = this.getGroup();
        String other$group = other.getGroup();
        if (this$group == null ? other$group != null : !this$group.equals(other$group)) {
            return false;
        }
        Params this$params = this.getParams();
        Params other$params = other.getParams();
        if (this$params == null ? other$params != null : !((Object)this$params).equals(other$params)) {
            return false;
        }
        ContentRule this$content = this.getContent();
        ContentRule other$content = other.getContent();
        if (this$content == null ? other$content != null : !((Object)this$content).equals(other$content)) {
            return false;
        }
        TocRule this$toc = this.getToc();
        TocRule other$toc = other.getToc();
        if (this$toc == null ? other$toc != null : !((Object)this$toc).equals(other$toc)) {
            return false;
        }
        DetailRule this$detail = this.getDetail();
        DetailRule other$detail = other.getDetail();
        if (this$detail == null ? other$detail != null : !((Object)this$detail).equals(other$detail)) {
            return false;
        }
        SearchRule this$search = this.getSearch();
        SearchRule other$search = other.getSearch();
        return !(this$search == null ? other$search != null : !((Object)this$search).equals(other$search));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AnalyzerRule;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getWeight();
        Boolean $enabled = this.getEnabled();
        result = result * 59 + ($enabled == null ? 43 : ((Object)$enabled).hashCode());
        Boolean $audio = this.getAudio();
        result = result * 59 + ($audio == null ? 43 : ((Object)$audio).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $site = this.getSite();
        result = result * 59 + ($site == null ? 43 : $site.hashCode());
        String $group = this.getGroup();
        result = result * 59 + ($group == null ? 43 : $group.hashCode());
        Params $params = this.getParams();
        result = result * 59 + ($params == null ? 43 : ((Object)$params).hashCode());
        ContentRule $content = this.getContent();
        result = result * 59 + ($content == null ? 43 : ((Object)$content).hashCode());
        TocRule $toc = this.getToc();
        result = result * 59 + ($toc == null ? 43 : ((Object)$toc).hashCode());
        DetailRule $detail = this.getDetail();
        result = result * 59 + ($detail == null ? 43 : ((Object)$detail).hashCode());
        SearchRule $search = this.getSearch();
        result = result * 59 + ($search == null ? 43 : ((Object)$search).hashCode());
        return result;
    }

    public String toString() {
        return "AnalyzerRule(name=" + this.getName() + ", site=" + this.getSite() + ", group=" + this.getGroup() + ", enabled=" + this.getEnabled() + ", audio=" + this.getAudio() + ", weight=" + this.getWeight() + ", params=" + this.getParams() + ", content=" + this.getContent() + ", toc=" + this.getToc() + ", detail=" + this.getDetail() + ", search=" + this.getSearch() + ")";
    }
}

