/*
 * Decompiled with CFR 0.152.
 */
package com.unclezs.novel.analyzer.core.matcher.matchers.text;

import com.unclezs.novel.analyzer.util.StringUtils;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.parser.ParseSettings;
import org.jsoup.parser.Parser;
import org.jsoup.safety.Whitelist;
import org.jsoup.select.Elements;

public class DefaultContentMatcher {
    public static final String BLANK = "\u3000";
    private static final String[] WHITELIST = new String[]{"br", "Br", "bR", "BR", "p", "P", "div", "Div", "dIv", "diV", "DIv", "DiV", "dIV", "DIV"};
    private static final String NEW_LINE_SYMBOL = "\u2665";
    private static final String P_BR_TAG = "<.*?(p|br).*?>";

    private DefaultContentMatcher() {
    }

    public static String matching(String originalText) {
        String cleanHtml = Jsoup.clean((String)originalText, (Whitelist)Whitelist.none().addTags(WHITELIST));
        String divHtml = StringUtils.remove(cleanHtml, BLANK);
        divHtml = StringUtils.replace(divHtml, "\n", "\n", NEW_LINE_SYMBOL);
        divHtml = StringUtils.replaceAllCaseInsensitive(divHtml, NEW_LINE_SYMBOL, P_BR_TAG);
        Parser parser = Parser.htmlParser();
        parser.settings(ParseSettings.preserveCase);
        Document document = parser.parseInput(divHtml, "");
        Elements divs = document.select("div");
        String text = "";
        int maxLen = 0;
        for (Element div : divs) {
            String ownText = div.ownText();
            if (ownText.length() <= maxLen) continue;
            text = div.ownText();
            maxLen = ownText.length();
        }
        return text.replace(NEW_LINE_SYMBOL, "\n");
    }
}

