/*
 * Decompiled with CFR 0.152.
 */
package com.unclezs.novel.analyzer.core.matcher.matchers;

import com.unclezs.novel.analyzer.core.matcher.MatcherAlias;
import com.unclezs.novel.analyzer.core.matcher.matchers.Matcher;
import com.unclezs.novel.analyzer.core.matcher.matchers.text.DefaultContentMatcher;
import com.unclezs.novel.analyzer.core.matcher.matchers.text.FullTextContentMatcher;
import com.unclezs.novel.analyzer.core.matcher.matchers.text.ParagraphContentMatcher;
import com.unclezs.novel.analyzer.core.rule.CommonRule;
import java.util.Collections;
import java.util.List;

public class DefaultTextMatcher
implements Matcher {
    public static final String FULL_TEXT = "FULL_TEXT";
    public static final String FULL_TEXT_ORDER = "3";
    public static final String PARAGRAPH = "PARAGRAPH";
    public static final String PARAGRAPH_ORDER = "2";
    public static final String DEFAULT_ORDER = "1";
    private static final DefaultTextMatcher ME = new DefaultTextMatcher();

    private DefaultTextMatcher() {
    }

    public static DefaultTextMatcher me() {
        return ME;
    }

    @Override
    public MatcherAlias[] aliases() {
        return new MatcherAlias[]{MatcherAlias.alias("auto".concat(":")), MatcherAlias.alias("auto")};
    }

    @Override
    public <E> List<E> list(String src, CommonRule listRule) {
        return Collections.emptyList();
    }

    @Override
    public <E> String one(E element, String rule) {
        String originalText = element.toString();
        switch (rule) {
            case "FULL_TEXT": 
            case "3": {
                return FullTextContentMatcher.matching(originalText);
            }
            case "PARAGRAPH": 
            case "2": {
                return ParagraphContentMatcher.matching(originalText);
            }
        }
        return DefaultContentMatcher.matching(originalText);
    }
}

