/*
 * Decompiled with CFR 0.152.
 */
package com.unclezs.novel.analyzer.core.matcher.matchers;

import com.unclezs.novel.analyzer.core.matcher.MatcherAlias;
import com.unclezs.novel.analyzer.core.matcher.matchers.Matcher;
import com.unclezs.novel.analyzer.core.rule.CommonRule;
import com.unclezs.novel.analyzer.model.Pair;
import com.unclezs.novel.analyzer.util.CollectionUtils;
import com.unclezs.novel.analyzer.util.StringUtils;
import com.unclezs.novel.analyzer.util.regex.RegexUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CssMatcher
implements Matcher {
    private static final Logger log = LoggerFactory.getLogger(CssMatcher.class);
    private static final CssMatcher ME = new CssMatcher();
    private static final String ABS_URL = "abs:";
    private static final Set<String> SUPPORT_ATTR = CollectionUtils.newSet("href", "src", "text", "ownText");

    private CssMatcher() {
    }

    public static CssMatcher me() {
        return ME;
    }

    @Override
    public MatcherAlias[] aliases() {
        return new MatcherAlias[]{MatcherAlias.alias("css".concat(":")), MatcherAlias.alias("css")};
    }

    @Override
    public <E> List<E> list(String src, CommonRule listRule) {
        if (StringUtils.isBlank(src)) {
            return new ArrayList();
        }
        Pair<String, String> css = this.getCss(listRule.getRule());
        return Jsoup.parse((String)src).select(css.getLeft());
    }

    @Override
    public <E> String one(E element, String rule) {
        if (element == null) {
            return null;
        }
        if (element instanceof Element) {
            return this.match((Element)element, rule);
        }
        return this.match(element.toString(), rule);
    }

    public String match(String src, String rule) {
        if (StringUtils.isBlank(src)) {
            return null;
        }
        return this.match((Element)Jsoup.parse((String)src), rule);
    }

    public String match(Element src, String cssQuery) {
        Pair<String, String> css = this.getCss(cssQuery);
        return this.match(src, css.getLeft(), css.getRight());
    }

    public String match(Element element, String cssQuery, String attr) {
        if (StringUtils.isEmpty(attr)) {
            return this.selectAllText(element, cssQuery, false);
        }
        switch (attr) {
            case "text": {
                return this.selectAllText(element, cssQuery, false);
            }
            case "ownText": {
                return this.selectAllText(element, cssQuery, true);
            }
        }
        return element.select(cssQuery).attr(attr);
    }

    private String selectAllText(Element element, String cssQuery, boolean isOwn) {
        Elements elements = element.select(cssQuery);
        if (CollectionUtils.isEmpty(elements)) {
            return "";
        }
        StringBuilder result = new StringBuilder();
        for (Element ele : elements) {
            result.append(isOwn ? ele.ownText() : ele.text());
            if (elements.size() <= 1) continue;
            result.append("\r\n");
        }
        return result.toString();
    }

    private boolean support(String attr) {
        return SUPPORT_ATTR.contains(attr) || attr.startsWith(ABS_URL) || RegexUtils.isWord(attr);
    }

    private Element selectFirst(Element document, String cssQuery) {
        Elements elements = document.select(cssQuery);
        if (elements.isEmpty()) {
            return null;
        }
        return (Element)elements.get(0);
    }

    private Pair<String, String> getCss(String cssQuery) {
        int mid = cssQuery.lastIndexOf("@");
        Pair<String, String> css = new Pair<String, String>();
        if (mid != -1) {
            String attr = cssQuery.substring(mid + 1);
            String cssSelector = cssQuery.substring(0, mid);
            if (this.support(attr)) {
                css.setLeft(cssSelector);
                css.setRight(attr);
                return css;
            }
        }
        css.setLeft(cssQuery);
        return css;
    }
}

