/*
 * Decompiled with CFR 0.152.
 */
package com.unclezs.novel.analyzer.core.matcher;

import com.unclezs.novel.analyzer.common.annotation.Alias;
import com.unclezs.novel.analyzer.core.matcher.MatcherManager;
import com.unclezs.novel.analyzer.core.matcher.matchers.Matcher;
import com.unclezs.novel.analyzer.core.matcher.matchers.RegexMatcher;
import com.unclezs.novel.analyzer.core.rule.CommonRule;
import com.unclezs.novel.analyzer.core.rule.ReplaceRule;
import com.unclezs.novel.analyzer.script.ScriptContext;
import com.unclezs.novel.analyzer.script.ScriptUtils;
import com.unclezs.novel.analyzer.util.BeanUtils;
import com.unclezs.novel.analyzer.util.CollectionUtils;
import com.unclezs.novel.analyzer.util.StringUtils;
import com.unclezs.novel.analyzer.util.regex.RegexUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Matchers {
    private static final Logger log = LoggerFactory.getLogger(Matchers.class);

    public static String match(Object src, String rule) {
        CommonRule commonRule = CommonRule.create(rule);
        return Matchers.match(src, commonRule);
    }

    public static String match(Object source, CommonRule rule) {
        String result = null;
        if (CommonRule.isEffective(rule)) {
            Matcher matcher = MatcherManager.getMatcher(rule.getType());
            result = matcher == null ? StringUtils.toStringNullToEmpty(source) : matcher.one(source, rule.getRule());
            result = Matchers.purify(rule.getReplace(), result);
            Object scriptResult = Matchers.handleScript(StringUtils.toStringNullToEmpty(source), result, rule.getScript());
            result = StringUtils.toStringNullToEmpty(scriptResult);
        }
        return StringUtils.isBlank(result) ? null : result;
    }

    public static Map<String, String> matchMultiple(Object source, Map<String, CommonRule> ruleMap) {
        String ruleType = ruleMap.entrySet().stream().filter(rule -> MatcherManager.getMatcher(((CommonRule)rule.getValue()).getType()) != null).findFirst().map(entry -> ((CommonRule)entry.getValue()).getType()).orElse(null);
        if (StringUtils.isNotBlank(ruleType)) {
            ruleMap.entrySet().stream().filter(rule -> MatcherManager.getMatcher(((CommonRule)rule.getValue()).getType()) == null).forEach(entry -> ((CommonRule)entry.getValue()).setType(ruleType));
        }
        HashMap<String, String> resultMap = new HashMap<String, String>(ruleMap.size() * 2);
        for (Map.Entry<String, CommonRule> ruleEntry : ruleMap.entrySet()) {
            String result = Matchers.match(source, ruleEntry.getValue());
            resultMap.put(ruleEntry.getKey(), result);
        }
        return resultMap;
    }

    public static <T> T matchMultiple(Object source, Map<String, CommonRule> ruleMap, Class<T> type) {
        return BeanUtils.mapToBean(Matchers.matchMultiple(source, ruleMap), type);
    }

    public static List<Object> matchList(String src, CommonRule rule) {
        ArrayList<Object> items = new ArrayList<Object>();
        Matchers.matchList(src, rule, items::add);
        return items;
    }

    public static List<Map<String, String>> matchList(String src, CommonRule listRule, Map<String, CommonRule> childRules) {
        ArrayList<Map<String, String>> items = new ArrayList<Map<String, String>>();
        Matchers.matchList(src, listRule, (Object element) -> {
            try {
                items.add(Matchers.matchMultiple(element, childRules));
            }
            catch (Exception error) {
                log.error("\u5339\u914d\u5217\u8868\u8fc7\u7a0b\u4e2d\u5931\u8d25\uff1a{}", (Object)error.getMessage(), (Object)error);
            }
        });
        return items;
    }

    public static void matchList(String src, CommonRule listRule, Consumer<Object> itemHandler) {
        List list = new ArrayList();
        Matcher matcher = MatcherManager.getMatcher(listRule.getType());
        if (matcher != null) {
            list = matcher.list(src, listRule);
        }
        if (StringUtils.isNotBlank(listRule.getScript())) {
            list = (List)Matchers.handleScript(src, StringUtils.toStringNullToEmpty(list), listRule.getScript());
        }
        for (Object element : list) {
            itemHandler.accept(element);
        }
    }

    public static <E> List<E> matchList(String src, CommonRule listRule, Map<String, CommonRule> childRules, Class<E> type) {
        List<Map<String, String>> resultsMap = Matchers.matchList(src, listRule, childRules);
        ArrayList<E> items = new ArrayList<E>();
        if (resultsMap != null) {
            for (Map<String, String> map : resultsMap) {
                items.add(BeanUtils.mapToBean(map, type));
            }
        }
        return items;
    }

    public static Map<String, CommonRule> getChildMap(String defaultType, Object obj, boolean ignore, String ... properties) {
        Class<?> clazz = obj.getClass();
        HashMap<String, CommonRule> map = new HashMap<String, CommonRule>(16);
        Set<String> ignoreFieldSet = CollectionUtils.set(false, properties);
        BeanUtils.getFields(clazz).stream().filter(f -> properties.length == 0 || ignore != ignoreFieldSet.contains(f.getName())).forEach(field -> {
            try {
                Object srcValue = field.get(obj);
                if (srcValue instanceof CommonRule) {
                    CommonRule value = (CommonRule)srcValue;
                    Alias alias = field.getAnnotation(Alias.class);
                    if (StringUtils.isNotBlank(defaultType) && StringUtils.isBlank(value.getType())) {
                        value.setType(defaultType);
                    }
                    if (!CommonRule.isEffective(value)) {
                        log.debug("\u65e0\u6548\u89c4\u5219\uff1a{}", (Object)value);
                        return;
                    }
                    if (alias != null) {
                        map.put(alias.value(), (CommonRule)srcValue);
                    } else {
                        map.put(field.getName(), (CommonRule)srcValue);
                    }
                }
            }
            catch (IllegalAccessException e) {
                log.error("BeanUtils\u83b7\u53d6\u5c5e\u6027\u5931\u8d25: {}", (Object)field.getName(), (Object)e);
            }
        });
        return map;
    }

    public static Map<String, CommonRule> getChildMap(String type, Object obj) {
        return Matchers.getChildMap(type, obj, true, new String[0]);
    }

    public static Map<String, CommonRule> getChildMap(Object obj) {
        return Matchers.getChildMap(null, obj, true, new String[0]);
    }

    private static String purify(Set<ReplaceRule> rules, String src) {
        if (CollectionUtils.isNotEmpty(rules)) {
            for (ReplaceRule rule : rules) {
                if (rule.getFrom().startsWith(RegexMatcher.REGEX_PREFIX)) {
                    String from = rule.getFrom().substring(RegexMatcher.REGEX_PREFIX.length());
                    if (StringUtils.isNotBlank(rule.getTo()) && rule.getTo().contains("$")) {
                        src = RegexUtils.replaceAll((CharSequence)src, from, rule.getTo());
                        continue;
                    }
                    src = src.replaceAll(from, rule.getTo());
                    continue;
                }
                src = src.replace(rule.getFrom(), rule.getTo());
            }
        }
        return src;
    }

    private static Object handleScript(String source, String result, String script) {
        Object ret = result;
        if (StringUtils.isNotBlank(script)) {
            ScriptContext.put("source", source);
            ScriptContext.put("result", result);
            ret = ScriptUtils.executeForResult(script, ScriptContext.current());
            ScriptContext.remove("result", "source");
            ScriptContext.removeIfEmpty();
        }
        return ret;
    }

    private Matchers() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

