/*
 * Decompiled with CFR 0.152.
 */
package com.unclezs.novel.analyzer.core.matcher;

import com.unclezs.novel.analyzer.core.matcher.MatcherAlias;
import com.unclezs.novel.analyzer.core.matcher.matchers.CssMatcher;
import com.unclezs.novel.analyzer.core.matcher.matchers.DefaultTextMatcher;
import com.unclezs.novel.analyzer.core.matcher.matchers.JsonMatcher;
import com.unclezs.novel.analyzer.core.matcher.matchers.Matcher;
import com.unclezs.novel.analyzer.core.matcher.matchers.RegexMatcher;
import com.unclezs.novel.analyzer.core.matcher.matchers.XpathMatcher;
import com.unclezs.novel.analyzer.util.StringUtils;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

public class MatcherManager {
    private static final Map<String, Matcher> SUPPORT_MATCHER = new LinkedHashMap<String, Matcher>();
    private static final Set<String> DEFAULT_ALIAS_SET = new HashSet<String>();

    public static void registerMatcher(Matcher matcher) {
        MatcherManager.registerMatcher(matcher, matcher.aliases());
    }

    public static void registerMatcher(Matcher matcher, String ... aliases) {
        for (String alias : aliases) {
            SUPPORT_MATCHER.put(alias, matcher);
        }
    }

    public static void registerMatcher(Matcher matcher, MatcherAlias ... aliases) {
        if (aliases == null) {
            return;
        }
        for (MatcherAlias alias : aliases) {
            if (alias.isDefault()) {
                DEFAULT_ALIAS_SET.add(alias.getName());
            }
            SUPPORT_MATCHER.put(alias.getName(), matcher);
        }
    }

    public static Matcher getMatcher(String alias) {
        if (StringUtils.isBlank(alias)) {
            return null;
        }
        return SUPPORT_MATCHER.get(alias);
    }

    public static Matcher getMatcher(String alias, Matcher matcher) {
        return SUPPORT_MATCHER.getOrDefault(alias, matcher);
    }

    public static Map<String, Matcher> all() {
        return Collections.unmodifiableMap(SUPPORT_MATCHER);
    }

    public static Set<String> aliased() {
        return SUPPORT_MATCHER.keySet();
    }

    public static Set<String> defaultAlias() {
        return Collections.unmodifiableSet(DEFAULT_ALIAS_SET);
    }

    public static boolean isDefaultAlias(String alias) {
        return DEFAULT_ALIAS_SET.contains(alias);
    }

    static {
        MatcherManager.registerMatcher(RegexMatcher.me());
        MatcherManager.registerMatcher(XpathMatcher.me());
        MatcherManager.registerMatcher(CssMatcher.me());
        MatcherManager.registerMatcher(JsonMatcher.me());
        MatcherManager.registerMatcher(DefaultTextMatcher.me());
    }
}

