/*
 * Decompiled with CFR 0.152.
 */
package com.unclezs.novel.analyzer.common.concurrent.factory;

import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import lombok.NonNull;

public class DaemonThreadFactory
implements ThreadFactory {
    private final AtomicInteger threadNumber = new AtomicInteger(1);
    private final String namePrefix;

    public DaemonThreadFactory(String name) {
        this.namePrefix = name + "-thread-";
    }

    @Override
    public Thread newThread(@NonNull Runnable r) {
        if (r == null) {
            throw new NullPointerException("r is marked non-null but is null");
        }
        Thread t = new Thread(Thread.currentThread().getThreadGroup(), r, this.namePrefix + this.threadNumber.getAndIncrement(), 0L);
        t.setDaemon(true);
        if (t.getPriority() != 5) {
            t.setPriority(5);
        }
        return t;
    }
}

