/*
 * Decompiled with CFR 0.152.
 */
package com.unclezs.novel.analyzer.common.cache;

import com.unclezs.novel.analyzer.common.cache.Cache;
import java.io.Serializable;
import java.util.Iterator;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Supplier;

public class WeakCache<K, V>
implements Iterable<Map.Entry<K, V>>,
Cache<K, V>,
Serializable {
    private static final long serialVersionUID = 1L;
    private final transient Map<K, V> cache;
    private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();

    public WeakCache() {
        this(new WeakHashMap());
    }

    public WeakCache(Map<K, V> initMap) {
        this.cache = initMap;
    }

    @Override
    public V get(K key) {
        this.lock.readLock().lock();
        try {
            V v = this.cache.get(key);
            return v;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V get(K key, Supplier<V> supplier) {
        V v;
        block6: {
            v = this.get(key);
            if (null == v && null != supplier) {
                this.lock.writeLock().lock();
                try {
                    v = this.cache.get(key);
                    if (null != v) break block6;
                    try {
                        v = supplier.get();
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                    this.cache.put(key, v);
                }
                finally {
                    this.lock.writeLock().unlock();
                }
            }
        }
        return v;
    }

    @Override
    public V put(K key, V value) {
        this.lock.writeLock().lock();
        try {
            this.cache.put(key, value);
        }
        finally {
            this.lock.writeLock().unlock();
        }
        return value;
    }

    public V remove(K key) {
        this.lock.writeLock().lock();
        try {
            V v = this.cache.remove(key);
            return v;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public void clear() {
        this.lock.writeLock().lock();
        try {
            this.cache.clear();
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public Iterator<Map.Entry<K, V>> iterator() {
        return this.cache.entrySet().iterator();
    }
}

