/*
 * Decompiled with CFR 0.152.
 */
package com.unclezs.novel.app.framework.util;

public class StrUtils {
    public static final char UNDERLINE = '_';
    public static final String EMPTY = "";

    private StrUtils() {
    }

    public static String toUnderlineCase(String str) {
        if (str == null) {
            return null;
        }
        char[] charArray = str.toCharArray();
        StringBuilder builder = new StringBuilder();
        int l = charArray.length;
        for (int i = 0; i < l; ++i) {
            if (charArray[i] >= 'A' && charArray[i] <= 'Z') {
                if (i != 0) {
                    builder.append("_");
                }
                int n = i;
                char c = (char)(charArray[n] + 32);
                charArray[n] = c;
                builder.append(c);
                continue;
            }
            builder.append(charArray[i]);
        }
        return builder.toString();
    }

    public static boolean isEmpty(CharSequence str) {
        return str == null || str.length() == 0;
    }

    public static boolean isNotEmpty(CharSequence str) {
        return !StrUtils.isEmpty(str);
    }

    public static boolean isBlank(CharSequence str) {
        int length;
        if (str != null && (length = str.length()) != 0) {
            for (int i = 0; i < length; ++i) {
                if (StrUtils.isBlankChar(str.charAt(i))) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean isBlankChar(int c) {
        return Character.isWhitespace(c) || Character.isSpaceChar(c) || c == 65279 || c == 8234;
    }

    public static boolean isNotBlank(CharSequence str) {
        return !StrUtils.isBlank(str);
    }

    public static boolean endWith(String src, String ... suffix) {
        for (String end : suffix) {
            if (!src.endsWith(end)) continue;
            return true;
        }
        return false;
    }
}

