/*
 * Decompiled with CFR 0.152.
 */
package com.unclezs.novel.app.framework.util;

import cn.hutool.core.util.ReflectUtil;
import com.unclezs.novel.app.framework.exception.ReflectionException;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Optional;

public class ReflectUtils {
    public static <T> Class<T> forName(String className) {
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            throw new ReflectionException(e);
        }
    }

    public static Class<?> getCallerClass() {
        Optional walk = StackWalker.getInstance(StackWalker.Option.RETAIN_CLASS_REFERENCE).walk(s -> s.skip(2L).findFirst().map(StackWalker.StackFrame::getDeclaringClass));
        return walk.orElse(null);
    }

    public static void setFieldValue(String fieldName, Object bean, Object value) {
        Field field = ReflectUtil.getField(bean.getClass(), (String)fieldName);
        if (field != null) {
            field.setAccessible(true);
            ReflectUtil.setFieldValue((Object)bean, (String)fieldName, (Object)value);
        }
    }

    public static <T> Class<T> getSuperClassGenericType(Class<?> clazz) {
        return ReflectUtils.getSuperClassGenericType(clazz, 0);
    }

    public static <T> Class<T> getSuperClassGenericType(Class<?> clazz, int index) throws IndexOutOfBoundsException {
        Type genType = clazz.getGenericSuperclass();
        if (!(genType instanceof ParameterizedType)) {
            return Object.class;
        }
        Type[] params = ((ParameterizedType)genType).getActualTypeArguments();
        if (index >= params.length || index < 0) {
            return Object.class;
        }
        if (!(params[index] instanceof Class)) {
            return Object.class;
        }
        return (Class)params[index];
    }
}

