/*
 * Decompiled with CFR 0.152.
 */
package com.unclezs.novel.app.framework.util;

import cn.hutool.cache.CacheUtil;
import cn.hutool.cache.impl.TimedCache;
import cn.hutool.core.io.FileUtil;
import cn.hutool.core.util.URLUtil;
import com.unclezs.novel.analyzer.util.uri.UrlUtils;
import java.io.File;
import java.util.function.Consumer;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.scene.image.Image;

public final class ImageLoader {
    private static final TimedCache<String, Image> IMAGE_CACHE = CacheUtil.newTimedCache((long)300000L);

    public static Image get(String url) {
        return (Image)IMAGE_CACHE.get((Object)url, true);
    }

    public static void load(String url, final Image defaultImage, final Consumer<Image> callback) {
        Image cacheImage = ImageLoader.get(url);
        if (cacheImage == null) {
            if (!UrlUtils.isHttpUrl((String)url) && FileUtil.exist((String)url)) {
                url = URLUtil.getURL((File)FileUtil.file((String)url)).toString();
            } else if (!UrlUtils.isHttpUrl((String)url)) {
                callback.accept(defaultImage);
                return;
            }
            final Image image = new Image(url, true);
            IMAGE_CACHE.put((Object)url, (Object)image);
            final String finalUrl = url;
            image.progressProperty().addListener(new InvalidationListener(){

                public void invalidated(Observable observable) {
                    if (image.getProgress() == 1.0) {
                        if (image.isError()) {
                            IMAGE_CACHE.put((Object)finalUrl, (Object)defaultImage);
                            callback.accept(defaultImage);
                        } else {
                            callback.accept(image);
                        }
                        image.progressProperty().removeListener((InvalidationListener)this);
                    }
                }
            });
        } else if (cacheImage.getProgress() != 1.0) {
            final Image image = new Image(url, true);
            final String finalUrl = url;
            image.progressProperty().addListener(new InvalidationListener(){

                public void invalidated(Observable observable) {
                    if (image.getProgress() == 1.0) {
                        callback.accept(ImageLoader.get(finalUrl));
                        image.progressProperty().removeListener((InvalidationListener)this);
                    }
                }
            });
        } else {
            callback.accept(cacheImage);
        }
    }

    private ImageLoader() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

