/*
 * Decompiled with CFR 0.152.
 */
package com.unclezs.novel.app.framework.support.hotkey;

import com.tulskiy.keymaster.common.HotKeyListener;
import com.tulskiy.keymaster.common.Provider;
import com.unclezs.novel.app.framework.executor.Executor;
import com.unclezs.novel.app.framework.support.hotkey.HotKeyCombination;
import com.unclezs.novel.app.framework.util.StrUtils;
import java.util.HashMap;
import java.util.Map;
import javafx.scene.input.KeyEvent;
import javax.swing.KeyStroke;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class HotKeyManager {
    private static final Logger log = LoggerFactory.getLogger(HotKeyManager.class);
    private static final Provider PROVIDER = Provider.getCurrentProvider((boolean)true);
    private static final Map<String, HotKeyCombination> HOT_KEY_COMBINATIONS = new HashMap<String, HotKeyCombination>(16);
    private static final Map<String, HotKeyCombination> GLOBAL_HOT_KEY_COMBINATIONS = new HashMap<String, HotKeyCombination>(16);

    public static HotKeyCombination getWindowHotKey(String key) {
        return HOT_KEY_COMBINATIONS.get(key);
    }

    public static boolean windowHotKeyMatch(String key, KeyEvent event) {
        HotKeyCombination combination = HOT_KEY_COMBINATIONS.get(key);
        if (combination == null) {
            return false;
        }
        return combination.getCombination().match(event);
    }

    public static void unbind() {
        PROVIDER.close();
    }

    public static void clearGlobal() {
        Executor.run(() -> {
            PROVIDER.reset();
            GLOBAL_HOT_KEY_COMBINATIONS.clear();
            log.debug("\u5168\u5c40\u70ed\u952e\u5df2\u6e05\u7a7a");
        });
    }

    public static void registerGlobal(HotKeyCombination combination, HotKeyListener hotKeyListener) {
        if (combination == null || HOT_KEY_COMBINATIONS.containsKey(combination.getStroke())) {
            return;
        }
        GLOBAL_HOT_KEY_COMBINATIONS.put(combination.getStroke(), combination);
        HotKeyManager.registerGlobal(combination.getKeyStroke(), hotKeyListener);
    }

    public static void updateGlobal(String oldStroke, HotKeyCombination combination, HotKeyListener listener) {
        HotKeyManager.unregisterGlobal(oldStroke);
        HotKeyManager.registerGlobal(combination, listener);
        log.debug("\u66f4\u65b0\u5168\u5c40\u70ed\u952e\uff1a{} -> {}", (Object)oldStroke, (Object)combination.getStroke());
    }

    private static void registerGlobal(KeyStroke keyStroke, HotKeyListener listener) {
        if (keyStroke != null && listener != null) {
            PROVIDER.register(keyStroke, listener);
            log.debug("\u6210\u529f\u6ce8\u518c\u3010\u5168\u5c40\u3011\u70ed\u952e\uff1a{}", (Object)keyStroke);
        }
    }

    public static void unregisterGlobal(String keyText) {
        if (StrUtils.isNotBlank(keyText)) {
            GLOBAL_HOT_KEY_COMBINATIONS.remove(keyText);
            KeyStroke stroke = KeyStroke.getKeyStroke(keyText);
            if (stroke != null) {
                PROVIDER.unregister(KeyStroke.getKeyStroke(keyText));
            }
            log.debug("\u53d6\u6d88\u3010\u5168\u5c40\u3011\u70ed\u952e\uff1a{}", (Object)keyText);
        }
    }

    public static void unregister(String keyText, boolean global) {
        if (global) {
            HotKeyManager.unregisterGlobal(keyText);
        } else {
            HotKeyManager.unregisterWindowHotkey(keyText);
        }
    }

    public static void registerWindowHotkey(HotKeyCombination combination) {
        if (combination == null || HOT_KEY_COMBINATIONS.containsKey(combination.getStroke())) {
            return;
        }
        HOT_KEY_COMBINATIONS.put(combination.getStroke(), combination);
        log.debug("\u6210\u529f\u6ce8\u518c\u3010\u7a97\u53e3\u3011\u70ed\u952e\uff1a{} , \u5f53\u524d\u70ed\u952e\u6570\u91cf\uff1a{}", (Object)combination, (Object)HOT_KEY_COMBINATIONS.size());
    }

    public static void unregisterWindowHotkey(String keyText) {
        if (StrUtils.isNotBlank(keyText)) {
            HOT_KEY_COMBINATIONS.remove(keyText);
            log.debug("\u53d6\u6d88\u3010\u7a97\u53e3\u3011\u70ed\u952e\uff1a{} , \u5f53\u524d\u70ed\u952e\u6570\u91cf\uff1a{}", (Object)keyText, (Object)HOT_KEY_COMBINATIONS.size());
        }
    }

    public static boolean existed(String stroke) {
        return HOT_KEY_COMBINATIONS.containsKey(stroke) || GLOBAL_HOT_KEY_COMBINATIONS.containsKey(stroke);
    }

    private HotKeyManager() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    public static Map<String, HotKeyCombination> getHOT_KEY_COMBINATIONS() {
        return HOT_KEY_COMBINATIONS;
    }
}

