/*
 * Decompiled with CFR 0.152.
 */
package com.unclezs.novel.app.framework.support.hotkey;

import com.unclezs.novel.analyzer.util.StringUtils;
import java.util.Objects;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyCodeCombination;
import javafx.scene.input.KeyCombination;
import javax.swing.KeyStroke;

public class HotKeyCombination {
    private String stroke;
    private KeyCombination combination;

    public HotKeyCombination(KeyCode keyCode, KeyCombination.Modifier ... modifiers) {
        this.combination = new KeyCodeCombination(keyCode, modifiers);
        StringBuilder keyStroke = new StringBuilder();
        for (KeyCombination.Modifier modifier : modifiers) {
            keyStroke.append(modifier.getKey().getName().toLowerCase()).append(" ");
        }
        keyStroke.append(keyCode.getName().toUpperCase());
        this.stroke = keyStroke.toString();
    }

    private HotKeyCombination() {
    }

    public static HotKeyCombination fromStroke(String stroke) {
        if (StringUtils.isBlank((CharSequence)stroke)) {
            return null;
        }
        HotKeyCombination hotKeyCombination = new HotKeyCombination();
        hotKeyCombination.setCombination(KeyCombination.keyCombination((String)stroke));
        hotKeyCombination.setStroke(stroke);
        return hotKeyCombination;
    }

    public KeyStroke getKeyStroke() {
        return KeyStroke.getKeyStroke(this.stroke);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HotKeyCombination that = (HotKeyCombination)o;
        return Objects.equals(this.stroke, that.stroke);
    }

    public int hashCode() {
        return Objects.hash(this.stroke);
    }

    public String toString() {
        return this.stroke;
    }

    public String getStroke() {
        return this.stroke;
    }

    public KeyCombination getCombination() {
        return this.combination;
    }

    public void setStroke(String stroke) {
        this.stroke = stroke;
    }

    public void setCombination(KeyCombination combination) {
        this.combination = combination;
    }
}

