/*
 * Decompiled with CFR 0.152.
 */
package com.unclezs.novel.app.framework.executor;

import com.unclezs.novel.analyzer.common.concurrent.ThreadUtils;
import com.unclezs.novel.analyzer.common.concurrent.factory.DaemonThreadFactory;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import javafx.application.Platform;

public final class Executor {
    private static final ScheduledThreadPoolExecutor SCHEDULED_THREAD_POOL_EXECUTOR = new ScheduledThreadPoolExecutor(1, (ThreadFactory)new DaemonThreadFactory("scheduled"));

    public static void run(Runnable runnable) {
        ThreadUtils.execute((Runnable)runnable);
    }

    public static ScheduledFuture<?> run(Runnable runnable, long delay) {
        return SCHEDULED_THREAD_POOL_EXECUTOR.schedule(runnable, delay, TimeUnit.MILLISECONDS);
    }

    public static void runFx(Runnable runnable, long delay) {
        Executor.run(() -> Executor.runFx(runnable), delay);
    }

    public static void runFx(Runnable runnable) {
        if (Platform.isFxApplicationThread()) {
            runnable.run();
        } else {
            Platform.runLater((Runnable)runnable);
        }
    }

    public static void runFxAndWait(Runnable task) {
        if (Platform.isFxApplicationThread()) {
            task.run();
            return;
        }
        CountDownLatch doneLatch = new CountDownLatch(1);
        Platform.runLater(() -> {
            try {
                task.run();
            }
            finally {
                doneLatch.countDown();
            }
        });
        try {
            doneLatch.await();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    private Executor() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

