/*
 * Decompiled with CFR 0.152.
 */
package com.unclezs.novel.app.framework.components.icon;

import cn.hutool.core.text.CharSequenceUtil;
import com.jfoenix.controls.JFXButton;
import com.unclezs.novel.app.framework.components.icon.Icon;
import com.unclezs.novel.app.framework.components.icon.IconFont;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javafx.beans.property.StringProperty;
import javafx.css.CssMetaData;
import javafx.css.SimpleStyleableStringProperty;
import javafx.css.Styleable;
import javafx.css.StyleableStringProperty;
import javafx.css.converter.StringConverter;
import javafx.scene.Cursor;
import javafx.scene.Node;
import javafx.scene.control.Labeled;
import javafx.scene.control.Tooltip;

public class IconButton
extends JFXButton {
    public static final String DEFAULT_STYLE_CLASS = "icon-button";
    private String tip;
    private StringProperty icon;

    public IconButton() {
        this(null);
    }

    public IconButton(String text) {
        this(text, "", null);
    }

    public IconButton(String icon, String tip) {
        this(null, icon, tip);
    }

    public IconButton(IconFont icon, String tip) {
        this(null, icon, tip);
    }

    public IconButton(String text, IconFont icon, String tip) {
        this(text, icon.name().toLowerCase(), tip);
    }

    public IconButton(String text, IconFont icon) {
        this(text, icon.name().toLowerCase(), null);
    }

    public IconButton(String text, String icon, String tip) {
        super(text);
        this.getStyleClass().add((Object)DEFAULT_STYLE_CLASS);
        this.setText(text);
        this.setIcon(icon);
        this.setTip(tip);
        this.setCursor(Cursor.HAND);
        this.setDisableVisualFocus(true);
    }

    public static List<CssMetaData<? extends Styleable, ?>> getClassCssMetaData() {
        return StyleAbleProperties.CHILD_STYLEABLES;
    }

    public String getIcon() {
        return (String)this.iconProperty().get();
    }

    public void setIcon(String icon) {
        this.iconProperty().set((Object)icon);
    }

    public void setIcon(Icon icon) {
        if (icon != null) {
            this.iconProperty().set((Object)icon.getValue().toString());
            this.setGraphic((Node)icon);
        }
    }

    public void setTip(String tip) {
        this.tip = tip;
        if (tip != null) {
            this.setTooltip(new Tooltip(tip));
        }
    }

    public StringProperty iconProperty() {
        if (this.icon == null) {
            this.icon = new SimpleStyleableStringProperty(StyleAbleProperties.ICON, (Object)this, "-fx-icon"){

                public void invalidated() {
                    if (CharSequenceUtil.isBlank((CharSequence)this.getValue())) {
                        IconButton.this.setGraphic(null);
                    } else if (IconButton.this.getGraphic() instanceof Icon) {
                        ((Icon)IconButton.this.getGraphic()).setValue(this.getValue());
                    } else {
                        IconButton.this.setGraphic((Node)new Icon(this.getValue()));
                    }
                }
            };
        }
        return this.icon;
    }

    public List<CssMetaData<? extends Styleable, ?>> getControlCssMetaData() {
        return IconButton.getClassCssMetaData();
    }

    public String getTip() {
        return this.tip;
    }

    private static class StyleAbleProperties {
        private static final CssMetaData<IconButton, String> ICON = new CssMetaData<IconButton, String>("-fx-icon", StringConverter.getInstance()){

            public boolean isSettable(IconButton control) {
                return control.icon == null || !control.icon.isBound();
            }

            public StyleableStringProperty getStyleableProperty(IconButton control) {
                return (StyleableStringProperty)control.icon;
            }
        };
        private static final List<CssMetaData<? extends Styleable, ?>> CHILD_STYLEABLES;

        private StyleAbleProperties() {
        }

        static {
            ArrayList styleables = new ArrayList(Labeled.getClassCssMetaData());
            Collections.addAll(styleables, ICON);
            CHILD_STYLEABLES = Collections.unmodifiableList(styleables);
        }
    }
}

