/*
 * Decompiled with CFR 0.152.
 */
package com.unclezs.novel.app.framework.components;

import com.unclezs.novel.app.framework.components.icon.Icon;
import com.unclezs.novel.app.framework.components.icon.IconFont;
import com.unclezs.novel.app.framework.core.AppContext;
import com.unclezs.novel.app.framework.executor.Executor;
import com.unclezs.novel.app.framework.util.NodeHelper;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.util.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Toast {
    private static final Logger log = LoggerFactory.getLogger(Toast.class);
    public static final String DEFAULT_STYLE_CLASS = "toast";
    public static final long DEFAULT_SHOW_TIME = 2000L;
    public static final int MAX_TOAST_COUNT = 3;
    private static final VBox BOX = NodeHelper.addClass(new VBox(), "box");

    public static void info(String message) {
        Toast.toast(null, message, Type.INFO, 2000L);
    }

    public static void info(StackPane container, String message) {
        Toast.toast(container, message, Type.INFO);
    }

    public static void warn(String message) {
        Toast.toast(null, message, Type.WARN, 2000L);
    }

    public static void warn(StackPane container, String message) {
        Toast.toast(container, message, Type.WARN);
    }

    public static void success(String message) {
        Toast.toast(null, message, Type.SUCCESS, 2000L);
    }

    public static void success(StackPane container, String message) {
        Toast.toast(container, message, Type.SUCCESS);
    }

    public static void error(String message) {
        Toast.toast(null, message, Type.ERROR, 2000L);
    }

    public static void error(StackPane container, String message) {
        Toast.toast(container, message, Type.ERROR);
    }

    public static void toast(StackPane container, String message, Type type) {
        Toast.toast(container, message, type, 2000L);
    }

    public static void toast(StackPane container, String message, Type type, long time) {
        if (container == null) {
            container = (StackPane)AppContext.getInstance().getPrimaryStage().getScene().getRoot();
        }
        if (container == null) {
            log.warn("\u5410\u53f8\u5bb9\u5668\u672a\u6307\u5b9a\uff0c\u5e76\u4e14\u6ca1\u6709\u627e\u5230\u9ed8\u8ba4\u5bb9\u5668\uff01");
            return;
        }
        Pair<StackPane, Node> toastPair = Toast.createToast(message, type);
        container.getChildren().add((Object)((Node)toastPair.getKey()));
        StackPane finalContainer = container;
        Executor.runFx(() -> {
            finalContainer.getChildren().remove(toastPair.getKey());
            BOX.getChildren().remove(toastPair.getValue());
        }, time);
    }

    private static Pair<StackPane, Node> createToast(String msg, Type type) {
        Label message = NodeHelper.addClass(new Label(msg, (Node)new Icon((Object)type.iconFont)), type.name().toLowerCase());
        if (BOX.getChildren().size() == 3) {
            BOX.getChildren().remove(0);
        }
        BOX.getChildren().add((Object)message);
        StackPane toast = NodeHelper.addClass(new StackPane(new Node[]{BOX}), DEFAULT_STYLE_CLASS);
        toast.setTranslateY(-60.0);
        toast.setMouseTransparent(true);
        toast.setFocusTraversable(true);
        return new Pair((Object)toast, (Object)message);
    }

    public static enum Type {
        INFO(IconFont.INFO),
        SUCCESS(IconFont.SUCCESS),
        ERROR(IconFont.ERROR),
        WARN(IconFont.WARN);

        private final IconFont iconFont;

        private Type(IconFont iconFont) {
            this.iconFont = iconFont;
        }

        public IconFont getIconFont() {
            return this.iconFont;
        }
    }
}

