/*
 * Decompiled with CFR 0.152.
 */
package com.unclezs.novel.app.framework.components;

import com.unclezs.novel.analyzer.util.StringUtils;
import com.unclezs.novel.app.framework.components.icon.IconButton;
import com.unclezs.novel.app.framework.components.icon.IconFont;
import com.unclezs.novel.app.framework.support.LocalizedSupport;
import com.unclezs.novel.app.framework.util.NodeHelper;
import java.util.Collections;
import java.util.List;
import javafx.beans.value.ObservableValue;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.event.EventType;
import javafx.scene.Node;
import javafx.scene.control.ComboBox;
import javafx.scene.control.TextField;
import javafx.scene.input.InputEvent;
import javafx.scene.input.KeyCode;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;

public class SearchBar
extends HBox
implements LocalizedSupport {
    public static final EventType<SearchEvent> ON_SEARCH = new EventType(InputEvent.ANY, "ON_SEARCH");
    public static final String DEFAULT_STYLE_CLASS = "search-bar";
    private final TextField input;
    private String prompt = this.localized("search.prompt");
    private ComboBox<String> typeBox;
    private EventHandler<? super SearchEvent> onSearch;

    public SearchBar() {
        NodeHelper.addClass(this, DEFAULT_STYLE_CLASS);
        this.input = new TextField();
        HBox.setHgrow((Node)this.input, (Priority)Priority.ALWAYS);
        this.input.setPromptText(this.prompt);
        IconButton searchButton = new IconButton(IconFont.SEARCH, this.localized("search"));
        searchButton.prefHeightProperty().bind((ObservableValue)this.input.heightProperty());
        this.getChildren().setAll((Object[])new Node[]{this.input, searchButton});
        this.input.setOnKeyPressed(event -> {
            if (event.getCode() == KeyCode.ENTER) {
                this.fire();
            }
        });
        searchButton.setOnMouseClicked(event -> this.fire());
    }

    public void focus() {
        this.input.requestFocus();
    }

    private void fire() {
        if (this.onSearch != null && StringUtils.isNotBlank((CharSequence)this.input.getText())) {
            this.onSearch.handle((Event)new SearchEvent(this.input.getText(), this.currentType()));
        }
    }

    public void addType(String type) {
        if (this.typeBox == null) {
            this.typeBox = new ComboBox();
            this.typeBox.setValue((Object)type);
            this.getChildren().add(0, this.typeBox);
        }
        this.typeBox.getItems().add((Object)type);
    }

    public void addTypes(String ... types) {
        for (String type : types) {
            this.addType(type);
        }
    }

    public void addTypes(List<String> types) {
        for (String type : types) {
            this.addType(type);
        }
    }

    public void removeType(String type) {
        if (this.typeBox == null) {
            return;
        }
        this.typeBox.getItems().remove((Object)type);
    }

    public void clearType() {
        if (this.typeBox != null) {
            this.typeBox.getItems().clear();
            this.getChildren().remove(this.typeBox);
            this.typeBox = null;
        }
    }

    public String getCurrentType() {
        if (this.typeBox == null) {
            return null;
        }
        return (String)this.typeBox.getValue();
    }

    public void setType(String type) {
        if (this.typeBox == null) {
            return;
        }
        this.typeBox.setValue((Object)type);
    }

    public List<String> getTypeItems() {
        if (this.typeBox == null) {
            return Collections.emptyList();
        }
        return this.typeBox.getItems();
    }

    public void setPrompt(String prompt) {
        this.prompt = prompt;
        this.input.setPromptText(prompt);
    }

    public String currentType() {
        if (this.typeBox == null) {
            return null;
        }
        return (String)this.typeBox.getValue();
    }

    @Override
    public String getBundleName() {
        return "widgets.common";
    }

    public TextField getInput() {
        return this.input;
    }

    public String getPrompt() {
        return this.prompt;
    }

    public ComboBox<String> getTypeBox() {
        return this.typeBox;
    }

    public EventHandler<? super SearchEvent> getOnSearch() {
        return this.onSearch;
    }

    public void setOnSearch(EventHandler<? super SearchEvent> onSearch) {
        this.onSearch = onSearch;
    }

    public static class SearchEvent
    extends InputEvent {
        private final String input;
        private final String type;

        public SearchEvent(String input, String type) {
            super(ON_SEARCH);
            this.input = input;
            this.type = type;
        }

        public String getInput() {
            return this.input;
        }

        public String getType() {
            return this.type;
        }
    }
}

