/*
 * Decompiled with CFR 0.152.
 */
package com.unclezs.novel.app.framework.components;

import com.jfoenix.controls.JFXSpinner;
import com.unclezs.novel.app.framework.components.ImageViewPlus;
import com.unclezs.novel.app.framework.util.ImageLoader;
import com.unclezs.novel.app.framework.util.NodeHelper;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.StackPane;

public class LoadingImageView
extends StackPane {
    public static final String DEFAULT_STYLE_CLASS = "loading-image-view";
    public static final String LOADING_STYLE_CLASS = "loading";
    private final JFXSpinner loading = new JFXSpinner();
    private final ImageView imageView;
    private Image defaultImage;

    public LoadingImageView(Image defaultImage) {
        this(defaultImage, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
    }

    public LoadingImageView() {
        this(null);
    }

    public LoadingImageView(Image defaultImage, double width, double height) {
        this.defaultImage = defaultImage;
        this.imageView = new ImageViewPlus(defaultImage, (Double)width, (Double)height);
        this.setPrefSize(width, height);
        this.setMaxSize(width, height);
        this.setMinSize(width, height);
        NodeHelper.addClass(this, DEFAULT_STYLE_CLASS);
        this.loading.setRadius(10.0);
        this.setPadding(new Insets(0.0));
    }

    private void setImage(Image image) {
        this.imageView.setImage(image);
        this.getChildren().setAll((Object[])new Node[]{this.imageView});
    }

    public void setImage(String url) {
        this.getChildren().setAll((Object[])new Node[]{this.loading});
        NodeHelper.addClass(this, LOADING_STYLE_CLASS);
        ImageLoader.load(url, this.defaultImage, image -> {
            this.setImage((Image)image);
            this.getStyleClass().remove((Object)LOADING_STYLE_CLASS);
        });
    }

    public void setDefaultImage(Image defaultImage) {
        this.defaultImage = defaultImage;
    }
}

