/*
 * Decompiled with CFR 0.152.
 */
package com.unclezs.novel.app.framework.components;

import com.unclezs.novel.analyzer.util.StringUtils;
import com.unclezs.novel.app.framework.components.icon.IconButton;
import com.unclezs.novel.app.framework.components.icon.IconFont;
import com.unclezs.novel.app.framework.util.NodeHelper;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.event.EventType;
import javafx.scene.Node;
import javafx.scene.control.TextField;
import javafx.scene.input.InputEvent;
import javafx.scene.input.KeyCode;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;

public class InputBox
extends HBox {
    public static final EventType<ActionClickedEvent> ON_ACTION_CLICKED = new EventType(InputEvent.ANY, "ON_ICON_CLICKED");
    public static final String DEFAULT_STYLE_CLASS = "input-box";
    private final TextField input;
    private final IconButton action;
    private String icon = IconFont.EDIT.name();
    private boolean validateEmpty = false;
    private String prompt;
    private EventHandler<? super ActionClickedEvent> onCommit;

    public InputBox(String text) {
        this();
        this.input.setText(text);
    }

    public InputBox() {
        NodeHelper.addClass(this, DEFAULT_STYLE_CLASS);
        this.input = new TextField();
        HBox.setHgrow((Node)this.input, (Priority)Priority.ALWAYS);
        this.action = new IconButton(null, this.icon, null);
        this.getChildren().setAll((Object[])new Node[]{this.input, this.action});
        this.input.setOnKeyPressed(event -> {
            if (event.getCode() == KeyCode.ENTER) {
                this.fire();
            }
        });
        this.action.setOnAction(event -> this.fire());
    }

    public void fire() {
        if (this.onCommit != null) {
            if (this.validateEmpty && StringUtils.isBlank((CharSequence)this.input.getText())) {
                return;
            }
            this.onCommit.handle((Event)new ActionClickedEvent(this.input.getText()));
        }
    }

    public void setIcon(String icon) {
        this.icon = icon;
        this.action.setIcon(icon);
    }

    public void focus() {
        this.input.requestFocus();
    }

    public void setPrompt(String prompt) {
        this.prompt = prompt;
        this.input.setPromptText(prompt);
    }

    public TextField getInput() {
        return this.input;
    }

    public IconButton getAction() {
        return this.action;
    }

    public String getIcon() {
        return this.icon;
    }

    public boolean isValidateEmpty() {
        return this.validateEmpty;
    }

    public void setValidateEmpty(boolean validateEmpty) {
        this.validateEmpty = validateEmpty;
    }

    public String getPrompt() {
        return this.prompt;
    }

    public EventHandler<? super ActionClickedEvent> getOnCommit() {
        return this.onCommit;
    }

    public void setOnCommit(EventHandler<? super ActionClickedEvent> onCommit) {
        this.onCommit = onCommit;
    }

    public static class ActionClickedEvent
    extends InputEvent {
        private final String input;

        public ActionClickedEvent(String input) {
            super(ON_ACTION_CLICKED);
            this.input = input;
        }

        public String getInput() {
            return this.input;
        }
    }
}

