/*
 * Decompiled with CFR 0.152.
 */
package com.unclezs.novel.app.framework.components;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javafx.beans.property.DoubleProperty;
import javafx.css.CssMetaData;
import javafx.css.SimpleStyleableDoubleProperty;
import javafx.css.Styleable;
import javafx.css.StyleableProperty;
import javafx.css.converter.SizeConverter;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;

public class ImageViewPlus
extends ImageView {
    private DoubleProperty fitWidth;
    private DoubleProperty fitHeight;

    public ImageViewPlus() {
    }

    public ImageViewPlus(String url) {
        super(url);
    }

    public ImageViewPlus(Image image) {
        super(image);
    }

    public ImageViewPlus(String url, Double fitWidth, Double fitHeight) {
        this(new Image(url), fitWidth, fitHeight);
    }

    public ImageViewPlus(Image image, Double fitWidth, Double fitHeight) {
        super(image);
        this.fitToWidthProperty().set(fitWidth.doubleValue());
        this.fitToHeightProperty().set(fitHeight.doubleValue());
    }

    public static List<CssMetaData<? extends Styleable, ?>> getClassCssMetaData() {
        return StyleableProperties.STYLEABLES;
    }

    public DoubleProperty fitToWidthProperty() {
        if (this.fitWidth == null) {
            this.fitWidth = new SimpleStyleableDoubleProperty(StyleableProperties.FIT_WIDTH, (Object)this, "-fx-fit-width"){

                protected void invalidated() {
                    ImageViewPlus.this.setFitWidth(this.getValue());
                }
            };
        }
        return this.fitWidth;
    }

    public DoubleProperty fitToHeightProperty() {
        if (this.fitHeight == null) {
            this.fitHeight = new SimpleStyleableDoubleProperty(StyleableProperties.FIT_WIDTH, (Object)this, "-fx-fit-height"){

                protected void invalidated() {
                    ImageViewPlus.this.setFitHeight(this.getValue());
                }
            };
        }
        return this.fitHeight;
    }

    public List<CssMetaData<? extends Styleable, ?>> getCssMetaData() {
        return ImageViewPlus.getClassCssMetaData();
    }

    private static class StyleableProperties {
        private static final CssMetaData<ImageViewPlus, Number> FIT_WIDTH = new CssMetaData<ImageViewPlus, Number>("-fx-fit-width", SizeConverter.getInstance()){

            public boolean isSettable(ImageViewPlus n) {
                return n.fitWidth == null || !n.fitWidth.isBound();
            }

            public StyleableProperty<Number> getStyleableProperty(ImageViewPlus n) {
                return (StyleableProperty)n.fitToWidthProperty();
            }
        };
        private static final CssMetaData<ImageViewPlus, Number> FIT_HEIGHT = new CssMetaData<ImageViewPlus, Number>("-fx-fit-height", SizeConverter.getInstance()){

            public boolean isSettable(ImageViewPlus n) {
                return n.fitHeight == null || !n.fitHeight.isBound();
            }

            public StyleableProperty<Number> getStyleableProperty(ImageViewPlus n) {
                return (StyleableProperty)n.fitToHeightProperty();
            }
        };
        private static final List<CssMetaData<? extends Styleable, ?>> STYLEABLES;

        private StyleableProperties() {
        }

        static {
            ArrayList styleables = new ArrayList(ImageView.getClassCssMetaData());
            Collections.addAll(styleables, FIT_HEIGHT, FIT_WIDTH);
            STYLEABLES = Collections.unmodifiableList(styleables);
        }
    }
}

