/*
 * Decompiled with CFR 0.152.
 */
package com.unclezs.novel.app.framework.components;

import com.unclezs.novel.app.framework.components.icon.IconButton;
import com.unclezs.novel.app.framework.components.icon.IconFont;
import com.unclezs.novel.app.framework.core.AppContext;
import com.unclezs.novel.app.framework.util.DesktopUtils;
import com.unclezs.novel.app.framework.util.NodeHelper;
import java.io.File;
import javafx.beans.NamedArg;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.control.TextField;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.stage.DirectoryChooser;
import javafx.stage.Window;

public class FileSelector
extends HBox {
    private final IconButton choose;
    private final TextField input;
    private IconButton open;
    private String promptText;
    private String text;
    private String chooseText;
    private String openText;

    public FileSelector(@NamedArg(value="chooseText") String chooseText) {
        this.choose = NodeHelper.addClass(new IconButton(chooseText, IconFont.DIR), "btn");
        this.input = new TextField();
        this.getChildren().addAll((Object[])new Node[]{this.input, this.choose});
        HBox.setHgrow((Node)this.input, (Priority)Priority.ALWAYS);
        this.setSpacing(10.0);
        this.choose.setOnAction(e -> {
            File file;
            DirectoryChooser chooser = new DirectoryChooser();
            File old = new File(this.input.getText());
            if (old.exists()) {
                chooser.setInitialDirectory(old);
            }
            if ((file = chooser.showDialog((Window)AppContext.getInstance().getPrimaryStage())) != null) {
                this.input.setText(file.getAbsolutePath());
            }
        });
    }

    public void setOnChoose(EventHandler<ActionEvent> eventHandler) {
        this.choose.setOnAction(eventHandler);
    }

    public void setPromptText(String promptText) {
        this.promptText = promptText;
        this.input.setPromptText(promptText);
    }

    public void setText(String text) {
        this.text = text;
        this.input.setText(text);
    }

    public void setChooseText(String chooseText) {
        this.chooseText = chooseText;
        this.choose.setText(chooseText);
    }

    public void setOpenText(String openText) {
        this.openText = openText;
        this.open = NodeHelper.addClass(new IconButton(openText, IconFont.OPEN_DIR), "btn");
        this.getChildren().add((Object)this.open);
        this.open.setOnAction(e -> {
            File dir = new File(this.input.getText());
            if (dir.exists()) {
                DesktopUtils.openDir(dir);
            }
        });
    }

    public IconButton getChoose() {
        return this.choose;
    }

    public TextField getInput() {
        return this.input;
    }

    public IconButton getOpen() {
        return this.open;
    }

    public String getPromptText() {
        return this.promptText;
    }

    public String getText() {
        return this.text;
    }

    public String getChooseText() {
        return this.chooseText;
    }

    public String getOpenText() {
        return this.openText;
    }
}

