/*
 * Decompiled with CFR 0.152.
 */
package com.j256.ormlite.table;

import com.j256.ormlite.dao.BaseDaoImpl;
import com.j256.ormlite.db.DatabaseType;
import com.j256.ormlite.field.FieldType;
import com.j256.ormlite.support.ConnectionSource;
import com.j256.ormlite.table.DatabaseTableConfig;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;

public class TableInfo<T, ID> {
    private static final FieldType[] NO_FOREIGN_COLLECTIONS = new FieldType[0];
    private final DatabaseType databaseType;
    private final Class<T> dataClass;
    private final String schemaName;
    private final String tableName;
    private final FieldType[] fieldTypes;
    private final FieldType[] foreignCollections;
    private final FieldType idField;
    private final boolean foreignAutoCreate;
    private Map<String, FieldType> fieldNameMap;

    @Deprecated
    public TableInfo(ConnectionSource connectionSource, BaseDaoImpl<T, ID> baseDaoImpl, Class<T> dataClass) throws SQLException {
        this(connectionSource.getDatabaseType(), dataClass);
    }

    public TableInfo(DatabaseType databaseType, Class<T> dataClass) throws SQLException {
        this(databaseType, DatabaseTableConfig.fromClass(databaseType, dataClass));
    }

    @Deprecated
    public TableInfo(DatabaseType databaseType, BaseDaoImpl<T, ID> baseDaoImpl, DatabaseTableConfig<T> tableConfig) throws SQLException {
        this(databaseType, tableConfig);
    }

    public TableInfo(DatabaseType databaseType, DatabaseTableConfig<T> tableConfig) throws SQLException {
        this.databaseType = databaseType;
        this.dataClass = tableConfig.getDataClass();
        this.schemaName = tableConfig.getSchemaName();
        this.tableName = tableConfig.getTableName();
        this.fieldTypes = tableConfig.getFieldTypes(databaseType);
        FieldType findIdFieldType = null;
        boolean foreignAutoCreate = false;
        int foreignCollectionCount = 0;
        for (FieldType fieldType : this.fieldTypes) {
            if (fieldType.isId() || fieldType.isGeneratedId() || fieldType.isGeneratedIdSequence()) {
                if (findIdFieldType != null) {
                    throw new SQLException("More than 1 idField configured for class " + this.dataClass + " (" + findIdFieldType + "," + fieldType + ")");
                }
                findIdFieldType = fieldType;
            }
            if (fieldType.isForeignAutoCreate()) {
                foreignAutoCreate = true;
            }
            if (!fieldType.isForeignCollection()) continue;
            ++foreignCollectionCount;
        }
        this.idField = findIdFieldType;
        this.foreignAutoCreate = foreignAutoCreate;
        if (foreignCollectionCount == 0) {
            this.foreignCollections = NO_FOREIGN_COLLECTIONS;
        } else {
            this.foreignCollections = new FieldType[foreignCollectionCount];
            foreignCollectionCount = 0;
            for (FieldType fieldType : this.fieldTypes) {
                if (!fieldType.isForeignCollection()) continue;
                this.foreignCollections[foreignCollectionCount] = fieldType;
                ++foreignCollectionCount;
            }
        }
    }

    public Class<T> getDataClass() {
        return this.dataClass;
    }

    public String getTableName() {
        return this.tableName;
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public FieldType[] getFieldTypes() {
        return this.fieldTypes;
    }

    public FieldType getFieldTypeByColumnName(String columnName) {
        FieldType fieldType;
        if (this.fieldNameMap == null) {
            HashMap<String, FieldType> map = new HashMap<String, FieldType>();
            for (FieldType fieldType2 : this.fieldTypes) {
                map.put(this.databaseType.downCaseString(fieldType2.getColumnName(), true), fieldType2);
            }
            this.fieldNameMap = map;
        }
        if ((fieldType = this.fieldNameMap.get(this.databaseType.downCaseString(columnName, true))) != null) {
            return fieldType;
        }
        for (FieldType fieldType2 : this.fieldTypes) {
            if (!fieldType2.getFieldName().equals(columnName)) continue;
            throw new IllegalArgumentException("You should use columnName '" + fieldType2.getColumnName() + "' for table " + this.tableName + " instead of fieldName '" + fieldType2.getFieldName() + "'");
        }
        throw new IllegalArgumentException("Unknown column name '" + columnName + "' in table " + this.tableName);
    }

    public FieldType getIdField() {
        return this.idField;
    }

    public String objectToString(T object) {
        StringBuilder sb = new StringBuilder(64);
        sb.append(object.getClass().getSimpleName());
        for (FieldType fieldType : this.fieldTypes) {
            sb.append(' ').append(fieldType.getColumnName()).append('=');
            try {
                sb.append(fieldType.extractJavaFieldValue(object));
            }
            catch (Exception e) {
                throw new IllegalStateException("Could not generate toString of field " + fieldType, e);
            }
        }
        return sb.toString();
    }

    public boolean isUpdatable() {
        return this.idField != null && this.fieldTypes.length > 1;
    }

    public boolean isForeignAutoCreate() {
        return this.foreignAutoCreate;
    }

    public FieldType[] getForeignCollections() {
        return this.foreignCollections;
    }

    public boolean hasColumnName(String columnName) {
        for (FieldType fieldType : this.fieldTypes) {
            if (!fieldType.getColumnName().equals(columnName)) continue;
            return true;
        }
        return false;
    }
}

