/*
 * Decompiled with CFR 0.152.
 */
package com.j256.ormlite.support;

import com.j256.ormlite.misc.SqlExceptionUtil;
import com.j256.ormlite.support.DatabaseConnection;
import com.j256.ormlite.support.DatabaseConnectionProxyFactory;
import java.lang.reflect.Constructor;
import java.sql.SQLException;

public class ReflectionDatabaseConnectionProxyFactory
implements DatabaseConnectionProxyFactory {
    private final Class<? extends DatabaseConnection> proxyClass;
    private final Constructor<? extends DatabaseConnection> constructor;

    public ReflectionDatabaseConnectionProxyFactory(Class<? extends DatabaseConnection> proxyClass) throws IllegalArgumentException {
        this.proxyClass = proxyClass;
        try {
            this.constructor = proxyClass.getConstructor(DatabaseConnection.class);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Could not find constructor with DatabaseConnection argument in " + proxyClass);
        }
    }

    @Override
    public DatabaseConnection createProxy(DatabaseConnection realConnection) throws SQLException {
        try {
            return this.constructor.newInstance(realConnection);
        }
        catch (Exception e) {
            throw SqlExceptionUtil.create("Could not create a new instance of " + this.proxyClass, e);
        }
    }
}

