/*
 * Decompiled with CFR 0.152.
 */
package com.j256.ormlite.logger;

import com.j256.ormlite.logger.LocalLog;
import com.j256.ormlite.logger.Log;
import com.j256.ormlite.logger.Logger;
import java.lang.reflect.Constructor;

public class LoggerFactory {
    public static final String LOG_TYPE_SYSTEM_PROPERTY = "com.j256.ormlite.logger.type";
    private static LogType logType;

    private LoggerFactory() {
    }

    public static Logger getLogger(Class<?> clazz) {
        return LoggerFactory.getLogger(clazz.getName());
    }

    public static Logger getLogger(String className) {
        if (logType == null) {
            logType = LoggerFactory.findLogType();
        }
        return new Logger(logType.createLog(className));
    }

    public static String getSimpleClassName(String className) {
        String[] parts = className.split("\\.");
        if (parts.length <= 1) {
            return className;
        }
        return parts[parts.length - 1];
    }

    private static LogType findLogType() {
        String logTypeString = System.getProperty(LOG_TYPE_SYSTEM_PROPERTY);
        if (logTypeString != null) {
            try {
                return LogType.valueOf(logTypeString);
            }
            catch (IllegalArgumentException e) {
                LocalLog log = new LocalLog(LoggerFactory.class.getName());
                log.log(Log.Level.WARNING, "Could not find valid log-type from system property 'com.j256.ormlite.logger.type', value '" + logTypeString + "'");
            }
        }
        for (LogType logType : LogType.values()) {
            if (!logType.isAvailable()) continue;
            return logType;
        }
        return LogType.LOCAL;
    }

    public static enum LogType {
        SLF4J("org.slf4j.LoggerFactory", "com.j256.ormlite.logger.Slf4jLoggingLog"),
        ANDROID("android.util.Log", "com.j256.ormlite.android.AndroidLog"),
        COMMONS_LOGGING("org.apache.commons.logging.LogFactory", "com.j256.ormlite.logger.CommonsLoggingLog"),
        LOG4J2("org.apache.logging.log4j.LogManager", "com.j256.ormlite.logger.Log4j2Log"),
        LOG4J("org.apache.log4j.Logger", "com.j256.ormlite.logger.Log4jLog"),
        LOCAL(LocalLog.class.getName(), LocalLog.class.getName()){

            @Override
            public Log createLog(String classLabel) {
                return new LocalLog(classLabel);
            }

            @Override
            public boolean isAvailable() {
                return true;
            }
        }
        ,
        JAVA_UTIL("java.util.logging.Logger", "com.j256.ormlite.logger.JavaUtilLog");

        private final String detectClassName;
        private final String logClassName;

        private LogType(String detectClassName, String logClassName) {
            this.detectClassName = detectClassName;
            this.logClassName = logClassName;
        }

        public Log createLog(String classLabel) {
            try {
                return this.createLogFromClassName(classLabel);
            }
            catch (Exception e) {
                LocalLog log = new LocalLog(classLabel);
                log.log(Log.Level.WARNING, "Unable to call constructor with single String argument for class " + this.logClassName + ", so had to use local log: " + e.getMessage());
                return log;
            }
        }

        public boolean isAvailable() {
            if (!this.isAvailableTestClass()) {
                return false;
            }
            try {
                Log log = this.createLogFromClassName(((Object)((Object)this)).getClass().getName());
                log.isLevelEnabled(Log.Level.INFO);
                return true;
            }
            catch (Exception e) {
                return false;
            }
        }

        private Log createLogFromClassName(String classLabel) throws Exception {
            Class<?> clazz = Class.forName(this.logClassName);
            Constructor<?> constructor = clazz.getConstructor(String.class);
            return (Log)constructor.newInstance(classLabel);
        }

        boolean isAvailableTestClass() {
            try {
                Class.forName(this.detectClassName);
                return true;
            }
            catch (Exception e) {
                return false;
            }
        }
    }
}

