/*
 * Decompiled with CFR 0.152.
 */
package com.j256.ormlite.logger;

import com.j256.ormlite.logger.Log;
import org.apache.commons.logging.LogFactory;

public class CommonsLoggingLog
implements Log {
    private final org.apache.commons.logging.Log log;

    public CommonsLoggingLog(String className) {
        this.log = LogFactory.getLog((String)className);
    }

    @Override
    public boolean isLevelEnabled(Log.Level level) {
        switch (level) {
            case TRACE: {
                return this.log.isTraceEnabled();
            }
            case DEBUG: {
                return this.log.isDebugEnabled();
            }
            case INFO: {
                return this.log.isInfoEnabled();
            }
            case WARNING: {
                return this.log.isWarnEnabled();
            }
            case ERROR: {
                return this.log.isErrorEnabled();
            }
            case FATAL: {
                return this.log.isFatalEnabled();
            }
        }
        return this.log.isInfoEnabled();
    }

    @Override
    public void log(Log.Level level, String msg) {
        switch (level) {
            case TRACE: {
                this.log.trace((Object)msg);
                break;
            }
            case DEBUG: {
                this.log.debug((Object)msg);
                break;
            }
            case INFO: {
                this.log.info((Object)msg);
                break;
            }
            case WARNING: {
                this.log.warn((Object)msg);
                break;
            }
            case ERROR: {
                this.log.error((Object)msg);
                break;
            }
            case FATAL: {
                this.log.fatal((Object)msg);
                break;
            }
            default: {
                this.log.info((Object)msg);
            }
        }
    }

    @Override
    public void log(Log.Level level, String msg, Throwable t) {
        switch (level) {
            case TRACE: {
                this.log.trace((Object)msg, t);
                break;
            }
            case DEBUG: {
                this.log.debug((Object)msg, t);
                break;
            }
            case INFO: {
                this.log.info((Object)msg, t);
                break;
            }
            case WARNING: {
                this.log.warn((Object)msg, t);
                break;
            }
            case ERROR: {
                this.log.error((Object)msg, t);
                break;
            }
            case FATAL: {
                this.log.fatal((Object)msg, t);
                break;
            }
            default: {
                this.log.info((Object)msg, t);
            }
        }
    }
}

