/*
 * Decompiled with CFR 0.152.
 */
package com.jfoenix.skins;

import com.jfoenix.controls.cells.editors.base.JFXTreeTableCell;
import com.jfoenix.controls.datamodels.treetable.RecursiveTreeObject;
import javafx.geometry.HPos;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.control.TreeItem;
import javafx.scene.control.TreeTableCell;
import javafx.scene.control.skin.TreeTableCellSkin;

public class JFXTreeTableCellSkin<S, T>
extends TreeTableCellSkin<S, T> {
    public JFXTreeTableCellSkin(TreeTableCell<S, T> treeTableCell) {
        super(treeTableCell);
    }

    protected void updateChildren() {
        super.updateChildren();
        this.updateDisclosureNode();
    }

    private void updateDisclosureNode() {
        Node disclosureNode = ((JFXTreeTableCell)this.getSkinnable()).getDisclosureNode();
        if (disclosureNode != null) {
            TreeItem item = ((TreeTableCell)this.getSkinnable()).getTreeTableRow().getTreeItem();
            Object value = item == null ? null : item.getValue();
            boolean disclosureVisible = value != null && !item.isLeaf() && value instanceof RecursiveTreeObject && ((RecursiveTreeObject)value).getGroupedColumn() == ((TreeTableCell)this.getSkinnable()).getTableColumn();
            disclosureNode.setVisible(disclosureVisible);
            if (!disclosureVisible) {
                this.getChildren().remove((Object)disclosureNode);
            } else if (disclosureNode.getParent() == null) {
                this.getChildren().add((Object)disclosureNode);
                disclosureNode.toFront();
            } else {
                disclosureNode.toBack();
            }
            if (disclosureNode.getScene() != null) {
                disclosureNode.applyCss();
            }
        }
    }

    protected void layoutChildren(double x, double y, double w, double h) {
        this.updateDisclosureNode();
        double disclosureWidth = 0.0;
        Node disclosureNode = ((JFXTreeTableCell)this.getSkinnable()).getDisclosureNode();
        if (disclosureNode.isVisible()) {
            Pos alignment = ((TreeTableCell)this.getSkinnable()).getAlignment();
            alignment = alignment == null ? Pos.CENTER_LEFT : alignment;
            this.layoutInArea(disclosureNode, x + 8.0, y, w, h, 0.0, Insets.EMPTY, false, false, HPos.LEFT, VPos.CENTER);
            disclosureWidth = disclosureNode.getLayoutBounds().getWidth() + 18.0;
        }
        super.layoutChildren(x + disclosureWidth, y, w - disclosureWidth, h);
    }
}

