/*
 * Decompiled with CFR 0.152.
 */
package com.jfoenix.skins;

import com.jfoenix.controls.JFXAutoCompletePopup;
import com.jfoenix.controls.JFXChip;
import com.jfoenix.controls.JFXChipView;
import com.jfoenix.controls.JFXDefaultChip;
import com.jfoenix.skins.JFXAutoCompletePopupSkin;
import com.sun.javafx.scene.control.behavior.BehaviorBase;
import com.sun.javafx.scene.control.behavior.FocusTraversalInputMap;
import com.sun.javafx.scene.control.inputmap.InputMap;
import com.sun.javafx.scene.traversal.Direction;
import java.util.List;
import javafx.beans.value.ObservableValue;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.collections.WeakListChangeListener;
import javafx.css.PseudoClass;
import javafx.event.Event;
import javafx.event.EventTarget;
import javafx.geometry.HPos;
import javafx.geometry.Insets;
import javafx.geometry.VPos;
import javafx.scene.AccessibleAttribute;
import javafx.scene.Node;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.SkinBase;
import javafx.scene.control.TextArea;
import javafx.scene.control.TextInputControl;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.FlowPane;
import javafx.scene.layout.Region;
import javafx.scene.text.Text;
import javafx.stage.Window;
import javafx.util.StringConverter;

public class JFXChipViewSkin<T>
extends SkinBase<JFXChipView<T>> {
    private static final PseudoClass PSEUDO_CLASS_ERROR = PseudoClass.getPseudoClass((String)"error");
    private CustomFlowPane root;
    private JFXChipView<T> control;
    private FakeFocusTextArea editor;
    private ChipsAutoComplete<T> autoCompletePopup;
    private boolean moveToNewLine = false;
    private boolean editorOnNewLine = true;
    private double availableWidth;
    private double requiredWidth;
    private final ListChangeListener<T> chipsChangeListeners = change -> {
        while (change.next()) {
            block1: for (Object item : change.getRemoved()) {
                for (int i = this.root.getChildren().size() - 2; i >= 0; --i) {
                    Node child = (Node)this.root.getChildren().get(i);
                    if (!(child instanceof JFXChip) || ((JFXChip)child).getItem() != item) continue;
                    this.root.getChildren().remove(i);
                    continue block1;
                }
            }
            for (Object item : change.getAddedSubList()) {
                this.createChip(item);
            }
        }
    };
    private final ScrollPane scrollPane;
    private ChipViewBehaviorBase<T> behavior;

    public JFXChipViewSkin(JFXChipView<T> control) {
        super(control);
        this.control = control;
        this.behavior = new ChipViewBehaviorBase<T>(control);
        this.root = new CustomFlowPane();
        this.root.getStyleClass().add((Object)"chips-pane");
        this.setupEditor();
        this.scrollPane = new ScrollPane((Node)this.root){

            public void requestFocus() {
                if (JFXChipViewSkin.this.getSkinnable() != null) {
                    ((JFXChipView)JFXChipViewSkin.this.getSkinnable()).requestFocus();
                }
            }
        };
        this.scrollPane.setFitToWidth(true);
        this.getChildren().add((Object)this.scrollPane);
        this.autoCompletePopup = (ChipsAutoComplete)((JFXChipView)this.getSkinnable()).getAutoCompletePopup();
        this.autoCompletePopup.setSelectionHandler(event -> {
            Object selectedItem = event.getObject();
            if (((JFXChipView)this.getSkinnable()).getSelectionHandler() != null) {
                selectedItem = ((JFXChipView)this.getSkinnable()).getSelectionHandler().apply(selectedItem);
            }
            ((JFXChipView)this.getSkinnable()).getChips().add(selectedItem);
            this.editor.clear();
        });
        this.autoCompletePopup.setShift(this.root.getVgap() * 2.0);
        this.root.vgapProperty().addListener(observable -> this.autoCompletePopup.setShift(this.root.getVgap() * 2.0));
        for (Object item : control.getChips()) {
            this.createChip(item);
        }
        control.getChips().addListener((ListChangeListener)new WeakListChangeListener(this.chipsChangeListeners));
    }

    protected void layoutChildren(double contentX, double contentY, double contentWidth, double contentHeight) {
        this.scrollPane.resizeRelocate(contentX, contentY, contentWidth, contentHeight);
    }

    private void setupEditor() {
        this.editor = new FakeFocusTextArea();
        this.editor.setManaged(false);
        this.editor.getStyleClass().add((Object)"editor");
        this.editor.setWrapText(true);
        this.editor.addEventFilter(KeyEvent.KEY_RELEASED, event -> {
            if (event.getCode() != KeyCode.ENTER) {
                ((JFXChipView)this.getSkinnable()).pseudoClassStateChanged(PSEUDO_CLASS_ERROR, false);
            }
        });
        this.editor.addEventFilter(KeyEvent.KEY_PRESSED, event -> {
            switch (event.getCode()) {
                case ENTER: {
                    if (!this.editor.getText().trim().isEmpty()) {
                        try {
                            StringConverter<T> sc = this.control.getConverter();
                            Object item = sc.fromString(this.editor.getText());
                            if (item != null) {
                                ((JFXChipView)this.getSkinnable()).getChips().add(item);
                            }
                            this.editor.clear();
                            this.autoCompletePopup.hide();
                        }
                        catch (Exception ex) {
                            ((JFXChipView)this.getSkinnable()).pseudoClassStateChanged(PSEUDO_CLASS_ERROR, true);
                        }
                    }
                    event.consume();
                    break;
                }
                case TAB: {
                    if (this.editor.getText().trim().isEmpty()) {
                        if (event.isShiftDown()) {
                            this.behavior.traverse((Node)this.getSkinnable(), Direction.PREVIOUS);
                        } else {
                            this.behavior.traverse((Node)this.editor, Direction.NEXT);
                        }
                    }
                    event.consume();
                    break;
                }
                case BACK_SPACE: {
                    ObservableList chips = ((JFXChipView)this.getSkinnable()).getChips();
                    int size = chips.size();
                    if (size <= 0 || !this.editor.getText().isEmpty()) break;
                    chips.remove(size - 1);
                    if (!this.autoCompletePopup.isShowing()) break;
                    this.autoCompletePopup.hide();
                    break;
                }
                case SPACE: {
                    if (!event.isControlDown() || this.autoCompletePopup.getFilteredSuggestions().isEmpty()) break;
                    this.autoCompletePopup.show((Node)this.editor);
                }
            }
        });
        this.editor.textProperty().addListener(observable -> {
            this.requiredWidth = this.editor.snappedLeftInset() + this.computeTextContentWidth((TextInputControl)this.editor) + this.editor.snappedRightInset() + 13.0;
            if (this.availableWidth < this.requiredWidth && !this.editorOnNewLine && !this.moveToNewLine) {
                this.moveToNewLine = true;
                this.root.requestLayout();
            } else if (this.availableWidth > this.requiredWidth && this.editorOnNewLine && this.moveToNewLine) {
                this.moveToNewLine = false;
                this.root.requestLayout();
            }
            this.autoCompletePopup.filter(item -> ((JFXChipView)this.getSkinnable()).getPredicate().test(item, this.editor.getText()));
            if (this.autoCompletePopup.getFilteredSuggestions().isEmpty()) {
                this.autoCompletePopup.hide();
            } else {
                this.autoCompletePopup.show((Node)this.editor);
            }
        });
        this.editor.promptTextProperty().bind((ObservableValue)this.control.promptTextProperty());
        this.root.getChildren().add((Object)this.editor);
        this.control.focusedProperty().addListener((obj, oldVal, newVal) -> {
            if (this.editor != null) {
                this.editor.setFakeFocus((boolean)newVal);
            }
        });
        this.control.addEventFilter(KeyEvent.ANY, ke -> {
            if (this.editor != null) {
                if (ke.getTarget().equals((Object)this.editor)) {
                    return;
                }
                if (ke.getTarget().equals(this.control)) {
                    switch (ke.getCode()) {
                        case ESCAPE: 
                        case F10: {
                            break;
                        }
                        default: {
                            this.editor.fireEvent((Event)ke.copyFor((Object)this.editor, (EventTarget)this.editor));
                            ke.consume();
                        }
                    }
                }
            }
        });
    }

    private void createChip(T item) {
        JFXChip chip = null;
        try {
            chip = ((JFXChipView)this.getSkinnable()).getChipFactory() != null ? ((JFXChipView)this.getSkinnable()).getChipFactory().apply((JFXChipView)this.getSkinnable(), (JFXChipView)((Object)item)) : new JFXDefaultChip<T>((JFXChipView)this.getSkinnable(), item);
        }
        catch (Exception e) {
            throw new RuntimeException("can't create chip for item '" + item + "' make sure to override the string converter and return null if text input is not valid.", e);
        }
        int size = this.root.getChildren().size();
        this.root.getChildren().add(size - 1, chip);
    }

    private double computeTextContentWidth(TextInputControl editor) {
        Text text = new Text(editor.getText());
        text.setFont(editor.getFont());
        text.applyCss();
        return text.getLayoutBounds().getWidth();
    }

    public void dispose() {
        super.dispose();
        if (this.behavior != null) {
            this.behavior.dispose();
        }
    }

    static final class ChipViewBehaviorBase<T>
    extends BehaviorBase<JFXChipView<T>> {
        public ChipViewBehaviorBase(JFXChipView<T> control) {
            super(control);
        }

        public InputMap<JFXChipView<T>> getInputMap() {
            return new InputMap((Node)((JFXChipView)this.getNode()));
        }

        public void traverse(Node node, Direction dir) {
            FocusTraversalInputMap.traverse((Node)node, (Direction)dir);
        }
    }

    private class CustomFlowPane
    extends FlowPane {
        double initOffset = 8.0;

        private CustomFlowPane() {
            this.addEventHandler(MouseEvent.MOUSE_CLICKED, event -> this.ensureVisible((Node)JFXChipViewSkin.this.editor));
        }

        private void ensureVisible(Node node) {
            double height = JFXChipViewSkin.this.scrollPane.getContent().getBoundsInLocal().getHeight();
            double y = node.getBoundsInParent().getMaxY();
            JFXChipViewSkin.this.scrollPane.setVvalue(y / height);
            if (((JFXChipView)JFXChipViewSkin.this.getSkinnable()).isFocused()) {
                node.requestFocus();
            }
        }

        protected void layoutChildren() {
            super.layoutChildren();
            this.updateEditorPosition();
        }

        protected double computePrefHeight(double forWidth) {
            JFXChipViewSkin.this.editor.setManaged(true);
            double height = super.computePrefHeight(forWidth);
            JFXChipViewSkin.this.editor.setManaged(false);
            return height;
        }

        private VPos getRowVAlignmentInternal() {
            VPos localPos = this.getRowValignment();
            return localPos == null ? VPos.CENTER : localPos;
        }

        private HPos getColumnHAlignmentInternal() {
            HPos localPos = this.getColumnHalignment();
            return localPos == null ? HPos.LEFT : localPos;
        }

        public void updateEditorPosition() {
            Insets insets = this.getInsets();
            double width = this.getWidth();
            double height = this.getHeight();
            double top = insets.getTop();
            double left = insets.getLeft();
            double bottom = insets.getBottom();
            double right = insets.getRight();
            double insideWidth = width - left - right;
            double insideHeight = height - top - bottom;
            double newLineEditorX = right + this.initOffset;
            double editorVInsets = JFXChipViewSkin.this.editor.snappedTopInset() + JFXChipViewSkin.this.editor.snappedBottomInset();
            List managedChildren = this.getManagedChildren();
            int mangedChildrenSize = managedChildren.size();
            if (mangedChildrenSize > 0) {
                Region lastChild = (Region)managedChildren.get(mangedChildrenSize - 1);
                double contentHeight = lastChild.getHeight() + lastChild.getLayoutY();
                JFXChipViewSkin.this.availableWidth = insideWidth - lastChild.getBoundsInParent().getMaxX();
                double minWidth = JFXChipViewSkin.this.editor.getMinWidth();
                minWidth = minWidth < 0.0 ? 100.0 : minWidth;
                minWidth = Math.max(minWidth, JFXChipViewSkin.this.requiredWidth);
                if (JFXChipViewSkin.this.availableWidth > JFXChipViewSkin.this.requiredWidth) {
                    JFXChipViewSkin.this.moveToNewLine = false;
                }
                if (JFXChipViewSkin.this.availableWidth < minWidth || JFXChipViewSkin.this.moveToNewLine) {
                    this.layoutInArea((Node)JFXChipViewSkin.this.editor, newLineEditorX, contentHeight + JFXChipViewSkin.this.root.getVgap(), insideWidth - this.initOffset, JFXChipViewSkin.this.editor.prefHeight(-1.0), 0.0, this.getColumnHAlignmentInternal(), VPos.TOP);
                    JFXChipViewSkin.this.editorOnNewLine = true;
                    this.ensureVisible((Node)JFXChipViewSkin.this.editor);
                } else {
                    this.layoutInArea((Node)JFXChipViewSkin.this.editor, lastChild.getBoundsInParent().getMaxX() + JFXChipViewSkin.this.root.getHgap(), lastChild.getLayoutY(), JFXChipViewSkin.this.availableWidth - JFXChipViewSkin.this.root.getHgap(), lastChild.getHeight() + editorVInsets, 0.0, this.getColumnHAlignmentInternal(), this.getRowVAlignmentInternal());
                    JFXChipViewSkin.this.editorOnNewLine = false;
                }
            } else {
                this.layoutInArea((Node)JFXChipViewSkin.this.editor, newLineEditorX, top, insideWidth - this.initOffset, JFXChipViewSkin.this.editor.prefHeight(-1.0), 0.0, this.getColumnHAlignmentInternal(), VPos.TOP);
                JFXChipViewSkin.this.editorOnNewLine = true;
                this.ensureVisible((Node)JFXChipViewSkin.this.editor);
            }
        }
    }

    public static class ChipsAutoComplete<T>
    extends JFXAutoCompletePopup<T> {
        private double shift = 0.0;
        private Text text;

        public ChipsAutoComplete() {
            this.getStyleClass().add((Object)"jfx-chips-popup");
        }

        void setShift(double shift) {
            this.shift = shift;
        }

        @Override
        public void show(Node node) {
            if (this.text == null) {
                this.text = (Text)node.lookup(".text");
            }
            node = this.text;
            if (!this.isShowing()) {
                if (node.getScene() == null || node.getScene().getWindow() == null) {
                    throw new IllegalStateException("Can not show popup. The node must be attached to a scene/window.");
                }
                Window parent = node.getScene().getWindow();
                this.show(parent, parent.getX() + node.localToScene(0.0, 0.0).getX() + node.getScene().getX(), parent.getY() + node.localToScene(0.0, 0.0).getY() + node.getScene().getY() + node.getLayoutBounds().getHeight() + this.shift);
                ((JFXAutoCompletePopupSkin)this.getSkin()).animate();
            } else {
                Window parent = node.getScene().getWindow();
                this.show(parent, parent.getX() + node.localToScene(0.0, 0.0).getX() + node.getScene().getX(), parent.getY() + node.localToScene(0.0, 0.0).getY() + node.getScene().getY() + node.getLayoutBounds().getHeight() + this.shift);
            }
        }
    }

    final class FakeFocusTextArea
    extends TextArea {
        FakeFocusTextArea() {
        }

        public void requestFocus() {
            if (JFXChipViewSkin.this.getSkinnable() != null) {
                ((JFXChipView)JFXChipViewSkin.this.getSkinnable()).requestFocus();
            }
        }

        public void setFakeFocus(boolean b) {
            this.setFocused(b);
        }

        public Object queryAccessibleAttribute(AccessibleAttribute attribute, Object ... parameters) {
            switch (attribute) {
                case FOCUS_ITEM: {
                    return JFXChipViewSkin.this.getSkinnable();
                }
            }
            return super.queryAccessibleAttribute(attribute, parameters);
        }
    }
}

