/*
 * Decompiled with CFR 0.152.
 */
package com.jfoenix.controls.pannable;

import com.jfoenix.bindings.CustomBidirectionalBinding;
import com.jfoenix.bindings.base.IPropertyConverter;
import com.jfoenix.controls.pannable.base.IPannablePane;
import java.util.function.Function;
import javafx.beans.binding.DoubleExpression;
import javafx.beans.property.Property;
import javafx.beans.value.ObservableNumberValue;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Insets;
import javafx.geometry.Orientation;
import javafx.scene.Node;
import javafx.scene.control.ScrollBar;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Region;

public class PannableScrollPane
extends Pane {
    private ScrollBar vBar = new ScrollBar();
    private ScrollBar hBar = new ScrollBar();
    private static final double SCROLL_PAD = 20.0;

    private void init() {
        this.getStyleClass().add((Object)"pannable-scroll-pane");
        this.getChildren().addAll((Object[])new Node[]{this.vBar, this.hBar});
        this.vBar.setManaged(false);
        this.vBar.setOrientation(Orientation.VERTICAL);
        this.hBar.setManaged(false);
        this.hBar.setOrientation(Orientation.HORIZONTAL);
    }

    public <P extends Region> PannableScrollPane(P pane) {
        super(new Node[]{pane});
        this.init();
        this.bindScrollBar(this.vBar, pane, (Property<Number>)pane.translateYProperty(), p -> p.heightProperty());
        this.bindScrollBar(this.hBar, pane, (Property<Number>)pane.translateXProperty(), p -> p.widthProperty());
    }

    <P extends Region> void bindScrollBar(ScrollBar bar, P pane, Property<Number> trans, Function<Region, DoubleExpression> propFun) {
        CustomBidirectionalBinding<Number, Number> binding = new CustomBidirectionalBinding<Number, Number>(trans, (Property<Number>)bar.valueProperty(), new IPropertyConverter<Number, Number>(){

            @Override
            public Number to(Number number) {
                return number.doubleValue() * -1.0;
            }

            @Override
            public Number from(Number number) {
                return number.doubleValue() * -1.0;
            }
        });
        binding.bindBi();
        bar.minProperty().bind((ObservableValue)((IPannablePane)pane).scaleProperty().negate());
        bar.maxProperty().bind((ObservableValue)propFun.apply(pane).add(20.0).multiply((ObservableNumberValue)((IPannablePane)pane).scaleProperty()).subtract((ObservableNumberValue)propFun.apply((Region)this)));
        bar.visibleProperty().bind((ObservableValue)bar.maxProperty().greaterThan(0));
    }

    public PannableScrollPane() {
        this.init();
    }

    protected void layoutChildren() {
        super.layoutChildren();
        double w = this.getWidth();
        double h = this.getHeight();
        Insets insets = this.getInsets();
        double prefWidth = this.vBar.prefWidth(-1.0);
        this.vBar.resizeRelocate(w - prefWidth - insets.getRight(), insets.getTop(), prefWidth, h - insets.getTop() - insets.getBottom());
        double prefHeight = this.hBar.prefHeight(-1.0);
        this.hBar.resizeRelocate(insets.getLeft(), h - prefHeight - insets.getBottom(), w - insets.getLeft() - insets.getRight(), prefHeight);
    }
}

