/*
 * Decompiled with CFR 0.152.
 */
package com.jfoenix.controls;

import com.jfoenix.assets.JFoenixResources;
import com.jfoenix.skins.JFXToggleNodeSkin;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javafx.beans.DefaultProperty;
import javafx.css.CssMetaData;
import javafx.css.SimpleStyleableBooleanProperty;
import javafx.css.SimpleStyleableObjectProperty;
import javafx.css.Styleable;
import javafx.css.StyleableBooleanProperty;
import javafx.css.StyleableObjectProperty;
import javafx.css.StyleableProperty;
import javafx.css.converter.BooleanConverter;
import javafx.css.converter.ColorConverter;
import javafx.scene.Node;
import javafx.scene.control.Skin;
import javafx.scene.control.ToggleButton;
import javafx.scene.paint.Color;

@DefaultProperty(value="graphic")
public class JFXToggleNode
extends ToggleButton {
    private static final String DEFAULT_STYLE_CLASS = "jfx-toggle-node";
    private StyleableObjectProperty<Color> selectedColor = new SimpleStyleableObjectProperty(StyleableProperties.SELECTED_COLOR, (Object)this, "selectedColor", (Object)Color.rgb((int)0, (int)0, (int)0, (double)0.2));
    private StyleableObjectProperty<Color> unSelectedColor = new SimpleStyleableObjectProperty(StyleableProperties.UNSELECTED_COLOR, (Object)this, "unSelectedCOlor", (Object)Color.TRANSPARENT);
    private StyleableBooleanProperty disableAnimation = new SimpleStyleableBooleanProperty(StyleableProperties.DISABLE_ANIMATION, (Object)this, "disableAnimation", false);
    private StyleableBooleanProperty disableVisualFocus = new SimpleStyleableBooleanProperty(StyleableProperties.DISABLE_VISUAL_FOCUS, (Object)this, "disableVisualFocus", false);

    public JFXToggleNode() {
        this.initialize();
    }

    public JFXToggleNode(String text) {
        super(text);
        this.initialize();
    }

    public JFXToggleNode(Node graphic) {
        super("", graphic);
        this.initialize();
    }

    protected Skin<?> createDefaultSkin() {
        return new JFXToggleNodeSkin(this);
    }

    private void initialize() {
        this.getStyleClass().add((Object)DEFAULT_STYLE_CLASS);
    }

    public String getUserAgentStylesheet() {
        return JFoenixResources.load("css/controls/jfx-toggle-node.css").toExternalForm();
    }

    public final StyleableObjectProperty<Color> selectedColorProperty() {
        return this.selectedColor;
    }

    public final Color getSelectedColor() {
        return this.selectedColor == null ? Color.rgb((int)0, (int)0, (int)0, (double)0.2) : (Color)this.selectedColorProperty().get();
    }

    public final void setSelectedColor(Color selectedColor) {
        this.selectedColorProperty().set((Object)selectedColor);
    }

    public final StyleableObjectProperty<Color> unSelectedColorProperty() {
        return this.unSelectedColor;
    }

    public final Color getUnSelectedColor() {
        return this.unSelectedColor == null ? Color.TRANSPARENT : (Color)this.unSelectedColorProperty().get();
    }

    public final void setUnSelectedColor(Color unSelectedColor) {
        this.unSelectedColorProperty().set((Object)unSelectedColor);
    }

    public final StyleableBooleanProperty disableAnimationProperty() {
        return this.disableAnimation;
    }

    public final Boolean isDisableAnimation() {
        return this.disableAnimation != null && this.disableAnimationProperty().get();
    }

    public final void setDisableAnimation(Boolean disabled) {
        this.disableAnimationProperty().set(disabled.booleanValue());
    }

    public final StyleableBooleanProperty disableVisualFocusProperty() {
        return this.disableVisualFocus;
    }

    public final Boolean isDisableVisualFocus() {
        return this.disableVisualFocus != null && this.disableVisualFocusProperty().get();
    }

    public final void setDisableVisualFocus(Boolean disabled) {
        this.disableVisualFocusProperty().set(disabled.booleanValue());
    }

    public List<CssMetaData<? extends Styleable, ?>> getControlCssMetaData() {
        return JFXToggleNode.getClassCssMetaData();
    }

    public static List<CssMetaData<? extends Styleable, ?>> getClassCssMetaData() {
        return StyleableProperties.CHILD_STYLEABLES;
    }

    private static class StyleableProperties {
        private static final CssMetaData<JFXToggleNode, Color> SELECTED_COLOR = new CssMetaData<JFXToggleNode, Color>("-jfx-toggle-color", ColorConverter.getInstance(), Color.rgb((int)255, (int)255, (int)255, (double)0.87)){

            public boolean isSettable(JFXToggleNode control) {
                return control.selectedColor == null || !control.selectedColor.isBound();
            }

            public StyleableProperty<Color> getStyleableProperty(JFXToggleNode control) {
                return control.selectedColorProperty();
            }
        };
        private static final CssMetaData<JFXToggleNode, Color> UNSELECTED_COLOR = new CssMetaData<JFXToggleNode, Color>("-jfx-untoggle-color", ColorConverter.getInstance(), Color.TRANSPARENT){

            public boolean isSettable(JFXToggleNode control) {
                return control.unSelectedColor == null || !control.unSelectedColor.isBound();
            }

            public StyleableProperty<Color> getStyleableProperty(JFXToggleNode control) {
                return control.unSelectedColorProperty();
            }
        };
        private static final CssMetaData<JFXToggleNode, Boolean> DISABLE_ANIMATION = new CssMetaData<JFXToggleNode, Boolean>("-jfx-disable-animation", BooleanConverter.getInstance(), Boolean.valueOf(false)){

            public boolean isSettable(JFXToggleNode control) {
                return control.disableAnimation == null || !control.disableAnimation.isBound();
            }

            public StyleableBooleanProperty getStyleableProperty(JFXToggleNode control) {
                return control.disableAnimationProperty();
            }
        };
        private static final CssMetaData<JFXToggleNode, Boolean> DISABLE_VISUAL_FOCUS = new CssMetaData<JFXToggleNode, Boolean>("-jfx-disable-visual-focus", BooleanConverter.getInstance(), Boolean.valueOf(false)){

            public boolean isSettable(JFXToggleNode control) {
                return control.disableVisualFocus == null || !control.disableVisualFocus.isBound();
            }

            public StyleableBooleanProperty getStyleableProperty(JFXToggleNode control) {
                return control.disableVisualFocusProperty();
            }
        };
        private static final List<CssMetaData<? extends Styleable, ?>> CHILD_STYLEABLES;

        private StyleableProperties() {
        }

        static {
            ArrayList styleables = new ArrayList(ToggleButton.getClassCssMetaData());
            Collections.addAll(styleables, SELECTED_COLOR, UNSELECTED_COLOR, DISABLE_ANIMATION, DISABLE_VISUAL_FOCUS);
            CHILD_STYLEABLES = Collections.unmodifiableList(styleables);
        }
    }
}

