{application,system_monitor,
    [{description,
         "Monitoring app that exports Erlang VM introspection data to the external databases."},
     {licenses,["Apache 2.0"]},
     {vsn,"3.0.3"},
     {registered,[]},
     {modules,
         [system_monitor,system_monitor_app,system_monitor_callback,
          system_monitor_collector,system_monitor_dummy,system_monitor_events,
          system_monitor_lib,system_monitor_pg,system_monitor_sup,
          system_monitor_top]},
     {mod,{system_monitor_app,[]}},
     {applications,[kernel,stdlib,supervisor3,epgsql]},
     {env,
         [{top_num_items,10},
          {top_sample_interval,2000},
          {top_sample_size,1000},
          {top_max_procs,15000},
          {top_significance_threshold,
              #{abs_reductions => 100,current_function => 0.01,
                initial_call => 0.01,memory => 0.01,num_processes => 100,
                reductions => 0.01}},
          {vips,[mnesia_tm,mnesia_locker]},
          {callback_mod,system_monitor_dummy},
          {db_hostname,"localhost"},
          {db_port,5432},
          {db_username,"system_monitor"},
          {db_password,"system_monitor_password"},
          {db_name,"system_monitor"},
          {db_connection_timeout,5000},
          {node_status_fun,undefined},
          {status_checks,
              [{system_monitor,check_process_count,false,30},
               {system_monitor,suspect_procs,false,5}]},
          {tick_interval,1000},
          {beam_events,
              [busy_port,busy_dist_port,{long_gc,500},{long_schedule,500}]},
          {suspect_procs_max_memory,524288000},
          {suspect_procs_max_message_queue_len,5000},
          {suspect_procs_max_total_heap_size,524288000}]}]}.
