/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.imaging.formats.pnm;

import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.imaging.ImageFormat;
import org.apache.commons.imaging.ImageInfo;
import org.apache.commons.imaging.ImagingException;
import org.apache.commons.imaging.common.ImageBuilder;
import org.apache.commons.imaging.formats.pnm.WhiteSpaceReader;

abstract class AbstractFileInfo {
    final int width;
    final int height;
    final boolean rawBits;

    static int readSample(InputStream is, int bytesPerSample) throws IOException {
        int sample = 0;
        for (int i = 0; i < bytesPerSample; ++i) {
            int nextByte = is.read();
            if (nextByte < 0) {
                throw new ImagingException("PNM: Unexpected EOF");
            }
            sample <<= 8;
            sample |= nextByte;
        }
        return sample;
    }

    static int scaleSample(int sample, float scale, int max) throws ImagingException {
        if (sample < 0) {
            throw new ImagingException("Negative pixel values are invalid in PNM files");
        }
        if (sample > max) {
            sample = 0;
        }
        return (int)((float)sample * scale / (float)max + 0.5f);
    }

    AbstractFileInfo(int width, int height, boolean rawBits) {
        this.width = width;
        this.height = height;
        this.rawBits = rawBits;
    }

    abstract int getBitDepth();

    abstract ImageInfo.ColorType getColorType();

    abstract ImageFormat getImageType();

    abstract String getImageTypeDescription();

    abstract String getMimeType();

    abstract int getNumComponents();

    abstract int getRgb(InputStream var1) throws IOException;

    abstract int getRgb(WhiteSpaceReader var1) throws IOException;

    abstract boolean hasAlpha();

    void newline() {
    }

    void readImage(ImageBuilder imageBuilder, InputStream is) throws IOException {
        if (!this.rawBits) {
            WhiteSpaceReader wsr = new WhiteSpaceReader(is);
            for (int y = 0; y < this.height; ++y) {
                for (int x = 0; x < this.width; ++x) {
                    int rgb = this.getRgb(wsr);
                    imageBuilder.setRgb(x, y, rgb);
                }
                this.newline();
            }
        } else {
            for (int y = 0; y < this.height; ++y) {
                for (int x = 0; x < this.width; ++x) {
                    int rgb = this.getRgb(is);
                    imageBuilder.setRgb(x, y, rgb);
                }
                this.newline();
            }
        }
    }
}

