/*
 * Decompiled with CFR 0.152.
 */
package com.minecraft.selector.utils;

import com.minecraft.selector.utils.ObjectPool;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;

public class RendererObjectPools {
    private static final RendererObjectPools INSTANCE = new RendererObjectPools();
    private final ObjectPool<int[]> intArrayPool = new ObjectPool<int[]>(() -> new int[2], 1000);
    private final ObjectPool<HashSet<String>> hashSetPool = new ObjectPool<HashSet>(HashSet::new, 100);
    private final ObjectPool<ArrayList<int[]>> arrayListPool = new ObjectPool<ArrayList>(ArrayList::new, 100);
    private final ObjectPool<HashMap<String, Object>> hashMapPool = new ObjectPool<HashMap>(HashMap::new, 100);

    private RendererObjectPools() {
    }

    public static RendererObjectPools getInstance() {
        return INSTANCE;
    }

    public int[] borrowIntArray() {
        return this.intArrayPool.borrow();
    }

    public void returnIntArray(int[] array) {
        if (array != null) {
            Arrays.fill(array, 0);
            this.intArrayPool.returnObject(array);
        }
    }

    public HashSet<String> borrowHashSet() {
        HashSet<String> set = this.hashSetPool.borrow();
        set.clear();
        return set;
    }

    public void returnHashSet(HashSet<String> set) {
        if (set != null) {
            set.clear();
            this.hashSetPool.returnObject(set);
        }
    }

    public ArrayList<int[]> borrowArrayList() {
        ArrayList<int[]> list = this.arrayListPool.borrow();
        list.clear();
        return list;
    }

    public void returnArrayList(ArrayList<int[]> list) {
        if (list != null) {
            list.clear();
            this.arrayListPool.returnObject(list);
        }
    }

    public HashMap<String, Object> borrowHashMap() {
        HashMap<String, Object> map = this.hashMapPool.borrow();
        map.clear();
        return map;
    }

    public void returnHashMap(HashMap<String, Object> map) {
        if (map != null) {
            map.clear();
            this.hashMapPool.returnObject(map);
        }
    }

    public String getAllStats() {
        return "\u5bf9\u8c61\u6c60\u7edf\u8ba1:\n  IntArray: " + this.intArrayPool.getStats() + "\n  HashSet: " + this.hashSetPool.getStats() + "\n  ArrayList: " + this.arrayListPool.getStats() + "\n  HashMap: " + this.hashMapPool.getStats();
    }

    public void clearAll() {
        this.intArrayPool.clear();
        this.hashSetPool.clear();
        this.arrayListPool.clear();
        this.hashMapPool.clear();
    }
}

