/*
 * Decompiled with CFR 0.152.
 */
package com.minecraft.selector.utils;

import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;

public class ObjectPool<T> {
    private final ConcurrentLinkedQueue<T> pool = new ConcurrentLinkedQueue();
    private final Supplier<T> factory;
    private final int maxSize;
    private final AtomicInteger currentSize;
    private final AtomicInteger borrowCount;
    private final AtomicInteger returnCount;

    public ObjectPool(Supplier<T> factory, int maxSize) {
        this.factory = factory;
        this.maxSize = maxSize;
        this.currentSize = new AtomicInteger(0);
        this.borrowCount = new AtomicInteger(0);
        this.returnCount = new AtomicInteger(0);
    }

    public T borrow() {
        this.borrowCount.incrementAndGet();
        T object = this.pool.poll();
        if (object == null) {
            object = this.factory.get();
        } else {
            this.currentSize.decrementAndGet();
        }
        return object;
    }

    public void returnObject(T object) {
        if (object != null && this.currentSize.get() < this.maxSize) {
            this.pool.offer(object);
            this.currentSize.incrementAndGet();
            this.returnCount.incrementAndGet();
        }
    }

    public int size() {
        return this.currentSize.get();
    }

    public String getStats() {
        return String.format("ObjectPool Stats: Size=%d/%d, Borrowed=%d, Returned=%d", this.currentSize.get(), this.maxSize, this.borrowCount.get(), this.returnCount.get());
    }

    public void clear() {
        this.pool.clear();
        this.currentSize.set(0);
    }
}

